/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.mas.events;

import com.blamejared.mas.reference.Reference;
import java.text.DecimalFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ClientEvents {
    private static final DecimalFormat timeFormatter = new DecimalFormat("########0.000");

    @SubscribeEvent
    public void renderGUI(RenderGameOverlayEvent.Text e) {
        if (Reference.DEVENV && (e.getType() == RenderGameOverlayEvent.ElementType.CROSSHAIRS || e.getType() == RenderGameOverlayEvent.ElementType.TEXT)) {
            Minecraft.func_71410_x().field_71466_p.func_78276_b("FPS: " + Minecraft.func_175610_ah(), 50, 50, 0xFF55FF);
            if (FMLCommonHandler.instance().getMinecraftServerInstance() != null) {
                Minecraft.func_71410_x().field_71466_p.func_78276_b(this.getTPS(FMLCommonHandler.instance().getMinecraftServerInstance(), Minecraft.func_71410_x().field_71439_g), 50, 70, 0xFF55FF);
            }
        }
    }

    private String getTPS(MinecraftServer server, EntityPlayerSP player) {
        int dim = player.field_70170_p.field_73011_w.getDimension();
        boolean summary = true;
        if (summary) {
            for (Integer dimId : DimensionManager.getIDs()) {
                double worldTickTime = (double)ClientEvents.mean((long[])server.worldTickTimes.get(dimId)) * 1.0E-6;
                double d = Math.min(1000.0 / worldTickTime, 20.0);
            }
            double meanTickTime = (double)ClientEvents.mean(server.field_71311_j) * 1.0E-6;
            double meanTPS = Math.min(1000.0 / meanTickTime, 20.0);
            return "MSPT: " + timeFormatter.format(meanTickTime) + " : TPS: " + timeFormatter.format(meanTPS);
        }
        return "";
    }

    private static long mean(long[] values) {
        long sum = 0L;
        for (long v : values) {
            sum += v;
        }
        return sum / (long)values.length;
    }
}

