/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.mas.api.recipes.machines;

import com.blamejared.mas.util.NBTHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;

public class RecipeMachineBase {
    private ItemStack input;
    private ItemStack output;
    private int inputAmount;
    private int outputAmount;

    public RecipeMachineBase(ItemStack input, ItemStack output, int inputAmount, int outputAmount) {
        this.input = input;
        this.input.func_77964_b(input.func_77952_i());
        this.output = output;
        this.output.func_77964_b(output.func_77952_i());
        this.inputAmount = inputAmount;
        this.outputAmount = outputAmount;
    }

    public int getOutputAmount() {
        return this.outputAmount;
    }

    public boolean matches(ItemStack stack) {
        int[] ids;
        for (int id : ids = OreDictionary.getOreIDs((ItemStack)stack)) {
            String name = OreDictionary.getOreName((int)id);
            if (!this.matches(name)) continue;
            return true;
        }
        return !stack.func_190926_b() && OreDictionary.itemMatches((ItemStack)stack, (ItemStack)this.input, (boolean)false);
    }

    private boolean matches(String oreDict) {
        NonNullList stacks = OreDictionary.getOres((String)oreDict);
        for (ItemStack stack : stacks) {
            if (!OreDictionary.itemMatches((ItemStack)stack, (ItemStack)this.input, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    public boolean matchesExact(ItemStack stack) {
        return NBTHelper.isInputEqual(this.input, stack);
    }

    public ItemStack getInput() {
        return this.input.func_77946_l();
    }

    public ItemStack getOutput() {
        return this.output.func_77946_l();
    }

    public int getInputamount() {
        return this.inputAmount;
    }

    public String toString() {
        return "RecipeMachineBase{input=" + this.input + ", output=" + this.output + ", inputAmount=" + this.inputAmount + ", outputAmount=" + this.outputAmount + '}';
    }
}

