/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.mas.blocks;

import com.blamejared.mas.blocks.generators.BlockGeneratorCoal;
import com.blamejared.mas.blocks.generators.BlockGeneratorTrash;
import com.blamejared.mas.blocks.misc.BlockCrank;
import com.blamejared.mas.reference.Reference;
import com.blamejared.mas.tileentities.generators.TileEntityGeneratorCoal;
import com.blamejared.mas.tileentities.generators.TileEntityGeneratorTrash;
import com.blamejared.mas.tileentities.misc.TileEntityCrank;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;

public class MBlocks {
    public static Map<String, Block> renderMap = new HashMap<String, Block>();
    public static Block GENERATOR_COAL = new BlockGeneratorCoal();
    public static Block GENERATOR_TRASH = new BlockGeneratorTrash();
    public static Block CRANK = new BlockCrank();

    public static void preInit() {
        MBlocks.registerBlock(GENERATOR_COAL, "generator_coal", TileEntityGeneratorCoal.class);
        MBlocks.registerBlock(GENERATOR_TRASH, "generator_trash", TileEntityGeneratorTrash.class);
        MBlocks.registerBlock(CRANK, "crank", TileEntityCrank.class);
    }

    private static void registerBlock(Block block, String key) {
        MBlocks.registerBlock(block, key, key, null, Reference.TAB);
    }

    private static void registerBlock(Block block, String key, String texture) {
        MBlocks.registerBlock(block, key, texture, null, Reference.TAB);
    }

    private static void registerBlock(Block block, String key, String texture, Class tile) {
        MBlocks.registerBlock(block, key, texture, tile, Reference.TAB);
    }

    private static void registerBlock(Block block, String key, Class tile) {
        MBlocks.registerBlock(block, key, key, tile, Reference.TAB);
    }

    private static void registerBlock(Block block, String key, Class tile, CreativeTabs tab) {
        MBlocks.registerBlock(block, key, key, tile, Reference.TAB);
    }

    private static void registerBlock(Block block, String key, String texture, Class tile, CreativeTabs tab) {
        block.func_149663_c(key).func_149647_a((CreativeTabs)Reference.TAB);
        if (Reference.DEVENV && FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            MBlocks.writeFile(key, texture);
        }
        renderMap.put(texture, block);
        GameRegistry.register((IForgeRegistryEntry)block, (ResourceLocation)new ResourceLocation("mas:" + key));
        GameRegistry.register((IForgeRegistryEntry)new ItemBlock(block), (ResourceLocation)new ResourceLocation("mas:" + key));
        if (tile != null) {
            GameRegistry.registerTileEntity((Class)tile, (String)key);
        }
    }

    private static void writeFile(String key, String texture) {
        try {
            FileWriter write;
            String line;
            ArrayList<String> content;
            Scanner scan;
            File base;
            File baseBlockState = new File(System.getProperty("user.home") + "/getFluxed/" + key + ".json");
            File baseBlockModel = new File(System.getProperty("user.home") + "/getFluxed/" + key + ".json");
            File baseItem = new File(System.getProperty("user.home") + "/getFluxed/" + key + ".json");
            if (System.getProperty("user.home").endsWith("Jared")) {
                baseBlockState = new File(new File(System.getProperty("user.dir")).getParentFile(), "src/main/resources/assets/mas/blockstates/" + key + ".json");
                baseBlockModel = new File(new File(System.getProperty("user.dir")).getParentFile(), "src/main/resources/assets/mas/models/block/" + key + ".json");
                baseItem = new File(new File(System.getProperty("user.dir")).getParentFile(), "src/main/resources/assets/mas/models/item/" + key + ".json");
            }
            if (!baseBlockState.exists()) {
                baseBlockState.createNewFile();
                base = new File(System.getProperty("user.home") + "/getFluxed/baseBlockState.json");
                scan = new Scanner(base);
                content = new ArrayList<String>();
                while (scan.hasNextLine()) {
                    line = scan.nextLine();
                    if (line.contains("%modid%")) {
                        line = line.replace("%modid%", "mas");
                    }
                    if (line.contains("%key%")) {
                        line = line.replace("%key%", key);
                    }
                    if (line.contains("%texture%")) {
                        line = line.replace("%texture%", texture);
                    }
                    content.add(line);
                }
                scan.close();
                write = new FileWriter(baseBlockState);
                for (String s : content) {
                    write.write(s + "\n");
                }
                write.close();
            }
            if (!baseBlockModel.exists()) {
                baseBlockModel.createNewFile();
                base = new File(System.getProperty("user.home") + "/getFluxed/baseBlockModel.json");
                scan = new Scanner(base);
                content = new ArrayList();
                while (scan.hasNextLine()) {
                    line = scan.nextLine();
                    if (line.contains("%modid%")) {
                        line = line.replace("%modid%", "mas");
                    }
                    if (line.contains("%key%")) {
                        line = line.replace("%key%", key);
                    }
                    if (line.contains("%texture%")) {
                        line = line.replace("%texture%", texture);
                    }
                    content.add(line);
                }
                scan.close();
                write = new FileWriter(baseBlockModel);
                for (String s : content) {
                    write.write(s + "\n");
                }
                write.close();
            }
            if (!baseItem.exists()) {
                baseItem.createNewFile();
                base = new File(System.getProperty("user.home") + "/getFluxed/baseBlockItem.json");
                scan = new Scanner(base);
                content = new ArrayList();
                while (scan.hasNextLine()) {
                    line = scan.nextLine();
                    if (line.contains("%modid%")) {
                        line = line.replace("%modid%", "mas");
                    }
                    if (line.contains("%key%")) {
                        line = line.replace("%key%", key);
                    }
                    if (line.contains("%texture%")) {
                        line = line.replace("%texture%", texture);
                    }
                    content.add(line);
                }
                scan.close();
                write = new FileWriter(baseItem);
                for (String s : content) {
                    write.write(s + "\n");
                }
                write.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

