/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.mas.api.generators;

import com.blamejared.mas.blocks.generators.base.BlockBaseGenerator;
import com.blamejared.mas.network.PacketHandler;
import com.blamejared.mas.network.messages.tiles.generator.MessageGenerator;
import javax.annotation.Nullable;
import net.darkhax.tesla.api.implementation.BaseTeslaContainer;
import net.darkhax.tesla.capability.TeslaCapabilities;
import net.minecraft.block.properties.IProperty;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public abstract class GeneratorBase
extends TileEntity
implements ITickable {
    public ItemStackHandler itemStackHandler;
    public int generationTimer = -1;
    public int generationTimerDefault = -1;
    public BaseTeslaContainer container;

    public GeneratorBase(int cap, int inventorySize) {
        this.container = new BaseTeslaContainer((long)cap, 50L, 50L);
        this.itemStackHandler = new ItemStackHandler(inventorySize);
    }

    public boolean isGenerating() {
        return this.generationTimer > -1;
    }

    protected boolean pushEnergy() {
        boolean pushed = false;
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            TileEntity tile = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(dir));
            if (tile == null || !tile.hasCapability(TeslaCapabilities.CAPABILITY_CONSUMER, dir.func_176734_d()) && !tile.hasCapability(TeslaCapabilities.CAPABILITY_HOLDER, dir.func_176734_d())) continue;
            BaseTeslaContainer cont = (BaseTeslaContainer)tile.getCapability(TeslaCapabilities.CAPABILITY_HOLDER, dir.func_176734_d());
            this.container.takePower(cont.givePower(this.container.takePower(this.container.getOutputRate(), true), false), false);
            if (this.field_145850_b.field_72995_K) continue;
            tile.func_70296_d();
            this.func_70296_d();
            pushed = true;
        }
        return pushed;
    }

    public void func_73660_a() {
        boolean sendUpdate = false;
        if (this.generationTimerDefault < 0 && this.container.getStoredPower() < this.container.getCapacity() && this.itemStackHandler.getStackInSlot(0) != null && this.canGenerateEnergy(this.itemStackHandler.getStackInSlot(0))) {
            this.generationTimer = this.getGenerationTime(this.itemStackHandler.getStackInSlot(0));
            this.generationTimerDefault = this.getGenerationTime(this.itemStackHandler.getStackInSlot(0));
            this.itemStackHandler.extractItem(0, 1, false);
            if (!this.field_145850_b.field_72995_K) {
                sendUpdate = true;
            }
        }
        if (this.generationTimer < 0) {
            this.generationTimerDefault = -1;
            this.generationTimer = -1;
            if (!this.field_145850_b.field_72995_K) {
                sendUpdate = true;
            }
        }
        if (this.container.getStoredPower() > 0L && this.pushEnergy()) {
            sendUpdate = true;
        }
        if (this.generationTimerDefault > 0 && this.container.getStoredPower() < this.container.getCapacity()) {
            --this.generationTimer;
            this.container.givePower((long)this.getEnergyGenerated(), false);
            if (!this.field_145850_b.field_72995_K) {
                sendUpdate = true;
            }
        }
        if (!this.field_145850_b.field_72995_K && sendUpdate) {
            this.func_70296_d();
            PacketHandler.INSTANCE.sendToAllAround((IMessage)new MessageGenerator(this), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), 128.0));
            this.field_145850_b.func_175685_c(this.func_174877_v(), this.func_145838_q(), true);
        }
        boolean active = true;
        if (!this.isGenerating()) {
            active = false;
        }
        if (this.itemStackHandler.getStackInSlot(0) == null && !this.isGenerating()) {
            active = false;
        }
        if (this.container.getStoredPower() == this.container.getCapacity()) {
            active = false;
        }
        if ((Boolean)this.field_145850_b.func_180495_p(this.func_174877_v()).func_177229_b((IProperty)BlockBaseGenerator.isActive) != active) {
            BlockBaseGenerator.setState(active, this.field_145850_b, this.field_174879_c);
        }
    }

    public void func_70296_d() {
        super.func_70296_d();
        PacketHandler.INSTANCE.sendToAllAround((IMessage)new MessageGenerator(this), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), 128.0));
    }

    public abstract boolean canGenerateEnergy(ItemStack var1);

    public abstract int getGenerationTime(ItemStack var1);

    public abstract int getEnergyGenerated();

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74782_a("items", (NBTBase)this.itemStackHandler.serializeNBT());
        nbt.func_74768_a("generationTimer", this.generationTimer);
        nbt.func_74768_a("generationTimerDefault", this.generationTimerDefault);
        nbt.func_74782_a("TeslaContainer", (NBTBase)this.container.serializeNBT());
        return nbt;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.itemStackHandler.deserializeNBT(nbt.func_74775_l("items"));
        this.generationTimer = nbt.func_74762_e("generationTimer");
        this.generationTimerDefault = nbt.func_74762_e("generationTimerDefault");
        this.container = new BaseTeslaContainer(nbt.func_74775_l("TeslaContainer"));
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_189515_b(tag);
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, tag);
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        this.func_145839_a(pkt.func_148857_g());
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == TeslaCapabilities.CAPABILITY_PRODUCER) {
            return (T)this.container;
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.itemStackHandler;
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == TeslaCapabilities.CAPABILITY_PRODUCER) {
            return true;
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }
}

