/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.mas.api.capabilities;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public class ItemStackHandlerAdvanced
implements IItemHandler,
IItemHandlerModifiable,
INBTSerializable<NBTTagCompound> {
    private List<ItemStack> stacks = new ArrayList<ItemStack>();

    public void addStack(ItemStack stack) {
        this.stacks.add(stack);
    }

    @Deprecated
    public void setStackInSlot(int slot, ItemStack stack) {
        this.validateSlotIndex(slot);
        if (ItemStack.func_77989_b((ItemStack)this.stacks.get(slot), (ItemStack)stack)) {
            return;
        }
        this.stacks.set(slot, stack);
        this.onContentsChanged(slot);
    }

    public int getSlots() {
        return this.stacks.size();
    }

    public ItemStack getStackInSlot(int slot) {
        this.validateSlotIndex(slot);
        return this.stacks.get(slot);
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        boolean reachedLimit;
        if (stack == null || stack.func_190916_E() == 0) {
            return null;
        }
        this.validateSlotIndex(slot);
        ItemStack existing = this.stacks.get(slot);
        int limit = this.getStackLimit(slot, stack);
        if (existing != null) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)existing)) {
                return stack;
            }
            limit -= existing.func_190916_E();
        }
        if (limit <= 0) {
            return stack;
        }
        boolean bl = reachedLimit = stack.func_190916_E() > limit;
        if (!simulate) {
            if (existing == null) {
                this.stacks.set(slot, reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)limit) : stack);
            } else {
                existing.func_190917_f(reachedLimit ? limit : stack.func_190916_E());
            }
            this.onContentsChanged(slot);
        }
        return reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.func_190916_E() - limit)) : null;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return null;
        }
        this.validateSlotIndex(slot);
        ItemStack existing = this.stacks.get(slot);
        if (existing == null) {
            return null;
        }
        int toExtract = Math.min(amount, existing.func_77976_d());
        if (existing.func_190916_E() <= toExtract) {
            if (!simulate) {
                this.stacks.set(slot, null);
                this.onContentsChanged(slot);
            }
            return existing;
        }
        if (!simulate) {
            this.stacks.set(slot, ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)(existing.func_190916_E() - toExtract)));
            this.onContentsChanged(slot);
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)toExtract);
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    protected int getStackLimit(int slot, ItemStack stack) {
        return stack.func_77976_d();
    }

    public NBTTagCompound serializeNBT() {
        NBTTagList nbtTagList = new NBTTagList();
        for (int i = 0; i < this.stacks.size(); ++i) {
            if (this.stacks.get(i) == null) continue;
            NBTTagCompound itemTag = new NBTTagCompound();
            itemTag.func_74768_a("Slot", i);
            this.stacks.get(i).func_77955_b(itemTag);
            nbtTagList.func_74742_a((NBTBase)itemTag);
        }
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74782_a("Items", (NBTBase)nbtTagList);
        nbt.func_74768_a("Size", this.stacks.size());
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.stacks = new ArrayList<ItemStack>();
        for (int i = 0; i < (nbt.func_150297_b("Size", 3) ? nbt.func_74762_e("Size") : this.stacks.size()); ++i) {
            this.stacks.add(null);
        }
        NBTTagList tagList = nbt.func_150295_c("Items", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound itemTags = tagList.func_150305_b(i);
            int slot = itemTags.func_74762_e("Slot");
            if (slot < 0 || slot >= this.stacks.size()) continue;
            this.stacks.set(slot, new ItemStack(itemTags));
        }
        this.onLoad();
    }

    protected void validateSlotIndex(int slot) {
        if (slot < 0 || slot >= this.stacks.size()) {
            throw new RuntimeException("Slot " + slot + " not in valid range - [0," + this.stacks.size() + ")");
        }
    }

    protected void onLoad() {
    }

    protected void onContentsChanged(int slot) {
    }

    public List<ItemStack> getStacks() {
        return this.stacks;
    }

    public void setStacks(List<ItemStack> stacks) {
        this.stacks = stacks;
    }
}

