/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.ironsmelters.item;

import com.blamejared.ironsmelters.ISCommon;
import com.blamejared.ironsmelters.api.SmelterType;
import com.blamejared.ironsmelters.block.ISBlocks;
import com.blamejared.ironsmelters.component.ISComponents;
import com.blamejared.ironsmelters.component.Upgrade;
import com.blamejared.ironsmelters.item.UpgradeItem;
import com.blamejared.ironsmelters.platform.IRegister;
import com.blamejared.ironsmelters.platform.Services;
import com.blamejared.ironsmelters.registry.RegistrationProvider;
import com.blamejared.ironsmelters.registry.RegistryObject;
import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import java.util.Map;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;

@AutoService(value={IRegister.class})
public class ISItems
implements IRegister {
    public static final RegistrationProvider<Item> ITEMS = RegistrationProvider.get(Registries.ITEM, "ironsmelters");
    private static final RegistrationProvider<CreativeModeTab> TABS = RegistrationProvider.get(Registries.CREATIVE_MODE_TAB, "ironsmelters");
    public static final RegistryObject<CreativeModeTab> TAB = TABS.register("ironsmelters", () -> Services.PLATFORM.creativeTabBuilder().displayItems((parameters, output) -> ISCommon.registerCreativeTabs(arg_0 -> ((CreativeModeTab.Output)output).accept(arg_0))).icon(() -> FURNACES.get(SmelterType.IRON).get().getDefaultInstance()).title((Component)Component.translatable((String)"itemGroup.ironsmelters")).build());
    public static final Map<SmelterType, RegistryObject<Item>> FURNACES = (Map)Util.make(() -> {
        ImmutableMap.Builder map = ImmutableMap.builder();
        for (SmelterType smelterType : SmelterType.ALL.values()) {
            map.put((Object)smelterType, ITEMS.blockItem(smelterType.id().getPath() + "_furnace", ISBlocks.FURNACES.get(smelterType), properties -> properties));
        }
        return map.build();
    });
    public static final Map<SmelterType, RegistryObject<Item>> BLAST_FURNACES = (Map)Util.make(() -> {
        ImmutableMap.Builder map = ImmutableMap.builder();
        for (SmelterType smelterType : SmelterType.ALL.values()) {
            map.put((Object)smelterType, ITEMS.blockItem(smelterType.id().getPath() + "_blast_furnace", ISBlocks.BLAST_FURNACES.get(smelterType), properties -> properties));
        }
        return map.build();
    });
    public static final Map<SmelterType, RegistryObject<Item>> SMOKERS = (Map)Util.make(() -> {
        ImmutableMap.Builder map = ImmutableMap.builder();
        for (SmelterType smelterType : SmelterType.ALL.values()) {
            map.put((Object)smelterType, ITEMS.blockItem(smelterType.id().getPath() + "_smoker", ISBlocks.SMOKER.get(smelterType), properties -> properties));
        }
        return map.build();
    });
    public static final Map<Pair<SmelterType, Optional<SmelterType>>, RegistryObject<Item>> UPGRADES = (Map)Util.make(() -> {
        ImmutableMap.Builder map = ImmutableMap.builder();
        for (SmelterType smelterType : SmelterType.ALL.values()) {
            for (Map.Entry<String, Optional<SmelterType>> upgrade : smelterType.upgradeFrom().entrySet()) {
                String key = "upgrade_" + upgrade.getValue().map(fromType -> fromType.id().getPath()).orElse("stone") + "_to_" + smelterType.id().getPath();
                Upgrade upgradeComponent = new Upgrade(upgrade.getValue(), smelterType, true);
                map.put((Object)Pair.of((Object)smelterType, upgrade.getValue()), ITEMS.item(key, properties -> new UpgradeItem(properties.component(ISComponents.UPGRADE.get(), (Object)upgradeComponent))));
            }
        }
        return map.build();
    });
}

