/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.ironsmelters.block.entity;

import com.blamejared.ironsmelters.api.SmelterType;
import com.blamejared.ironsmelters.block.ISAbstractFurnaceBlock;
import com.blamejared.ironsmelters.mixin.AccessAbstractFurnaceBlockEntity;
import com.blamejared.ironsmelters.platform.Services;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public abstract class AbstractISBlockEntity
extends AbstractFurnaceBlockEntity {
    private final SmelterType type;
    private final Component defaultName;
    private float tickAccumulator = 0.0f;

    protected AbstractISBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState blockState, RecipeType<? extends AbstractCookingRecipe> recipeType) {
        super(type, pos, blockState, recipeType);
        Block block = this.getBlockState().getBlock();
        if (!(block instanceof ISAbstractFurnaceBlock)) {
            throw new IllegalStateException("Expected ISAbstractFurnaceBlock");
        }
        ISAbstractFurnaceBlock block2 = (ISAbstractFurnaceBlock)block;
        this.type = block2.smelterType();
        this.defaultName = block2.getName();
    }

    protected Component getDefaultName() {
        return this.defaultName;
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, AbstractISBlockEntity blockEntity) {
        boolean hasFuel;
        AccessAbstractFurnaceBlockEntity access = blockEntity.access();
        boolean wasLit = access.callIsLit();
        boolean changed = false;
        if (access.callIsLit()) {
            access.setLitTime(access.getLitTime() - 1);
        }
        ItemStack fuel = (ItemStack)blockEntity.items.get(1);
        ItemStack input = (ItemStack)blockEntity.items.get(0);
        boolean hasInput = !input.isEmpty();
        boolean bl = hasFuel = !fuel.isEmpty();
        if (access.callIsLit() || hasFuel && hasInput) {
            RecipeHolder recipeholder = null;
            if (hasInput) {
                recipeholder = access.getQuickCheck().getRecipeFor((RecipeInput)new SingleRecipeInput(input), level).orElse(null);
            }
            int maxStackSize = blockEntity.getMaxStackSize();
            if (!access.callIsLit() && Services.PLATFORM.canBurn(level.registryAccess(), recipeholder, (NonNullList<ItemStack>)blockEntity.items, maxStackSize, blockEntity)) {
                access.setLitTime(blockEntity.getBurnDuration(fuel));
                access.setLitDuration(access.getLitTime());
                if (access.callIsLit()) {
                    changed = true;
                    if (hasFuel) {
                        Item fuelItem = fuel.getItem();
                        fuel.shrink(1);
                        if (fuel.isEmpty()) {
                            Item remainder = fuelItem.getCraftingRemainingItem();
                            blockEntity.items.set(1, (Object)(remainder == null ? ItemStack.EMPTY : new ItemStack((ItemLike)remainder)));
                        }
                    }
                }
            }
            if (access.callIsLit() && Services.PLATFORM.canBurn(level.registryAccess(), recipeholder, (NonNullList<ItemStack>)blockEntity.items, maxStackSize, blockEntity)) {
                blockEntity.tickAccumulator += blockEntity.type().config().get().furnaceMultiplier();
                int passedTicks = (int)Math.floor(blockEntity.tickAccumulator);
                blockEntity.tickAccumulator -= (float)passedTicks;
                access.setCookingProgress(access.getCookingProgress() + passedTicks);
                if (access.getCookingProgress() >= access.getCookingTotalTime()) {
                    blockEntity.tickAccumulator = 0.0f;
                    access.setCookingProgress(0);
                    access.setCookingTotalTime(AccessAbstractFurnaceBlockEntity.callGetTotalCookTime(level, blockEntity));
                    if (Services.PLATFORM.burn(level.registryAccess(), recipeholder, (NonNullList<ItemStack>)blockEntity.items, maxStackSize, blockEntity)) {
                        blockEntity.setRecipeUsed(recipeholder);
                    }
                    changed = true;
                }
            } else {
                blockEntity.tickAccumulator = 0.0f;
                access.setCookingProgress(0);
            }
        } else if (access.getCookingProgress() > 0) {
            blockEntity.tickAccumulator = 0.0f;
            access.setCookingProgress(Mth.clamp((int)(access.getCookingProgress() - 2), (int)0, (int)access.getCookingTotalTime()));
        }
        if (wasLit != access.callIsLit()) {
            changed = true;
            state = (BlockState)state.setValue((Property)AbstractFurnaceBlock.LIT, (Comparable)Boolean.valueOf(access.callIsLit()));
            level.setBlock(pos, state, 3);
        }
        if (changed) {
            AbstractISBlockEntity.setChanged((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    private AccessAbstractFurnaceBlockEntity access() {
        return (AccessAbstractFurnaceBlockEntity)((Object)this);
    }

    public SmelterType type() {
        return this.type;
    }
}

