/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.ironsmelters.data;

import com.blamejared.ironsmelters.ISConstants;
import com.blamejared.ironsmelters.api.SmelterType;
import com.blamejared.ironsmelters.item.ISItems;
import com.mojang.datafixers.util.Pair;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.Tags;

public class ISRecipesProvider
extends RecipeProvider {
    public ISRecipesProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> provider) {
        super(output, provider);
    }

    protected void buildRecipes(RecipeOutput output) {
        this.furnace(output, "furnace", "copper", SmelterType.COPPER, (TagKey<Item>)Tags.Items.INGOTS_COPPER, (ItemLike)Items.FURNACE);
        this.cheapOutline(output, "copper_furnace", "iron", "furnace", (Supplier<Item>)ISItems.FURNACES.get(SmelterType.IRON), (TagKey<Item>)Tags.Items.INGOTS_IRON, (ItemLike)ISItems.FURNACES.get(SmelterType.COPPER).get());
        this.furnace(output, "furnace", "iron", SmelterType.IRON, (TagKey<Item>)Tags.Items.INGOTS_IRON, (ItemLike)Items.FURNACE);
        this.furnace(output, "iron_furnace", "gold", SmelterType.GOLD, (TagKey<Item>)Tags.Items.INGOTS_GOLD, (ItemLike)ISItems.FURNACES.get(SmelterType.IRON).get());
        this.cheapOutline(output, "gold_furnace", "diamond", "furnace", (Supplier<Item>)ISItems.FURNACES.get(SmelterType.DIAMOND), (TagKey<Item>)Tags.Items.GEMS_DIAMOND, (ItemLike)ISItems.FURNACES.get(SmelterType.GOLD).get());
        this.furnace(output, "diamond_furnace", "obsidian", SmelterType.OBSIDIAN, (TagKey<Item>)Tags.Items.OBSIDIANS_NORMAL, (ItemLike)ISItems.FURNACES.get(SmelterType.DIAMOND).get());
        this.blastFurnace(output, "blast_furnace", "copper", SmelterType.COPPER, (TagKey<Item>)Tags.Items.INGOTS_COPPER, (ItemLike)Items.BLAST_FURNACE);
        this.cheapOutline(output, "copper_blast_furnace", "iron", "blast_furnace", (Supplier<Item>)ISItems.BLAST_FURNACES.get(SmelterType.IRON), (TagKey<Item>)Tags.Items.INGOTS_IRON, (ItemLike)ISItems.BLAST_FURNACES.get(SmelterType.COPPER).get());
        this.blastFurnace(output, "blast_furnace", "iron", SmelterType.IRON, (TagKey<Item>)Tags.Items.INGOTS_IRON, (ItemLike)Items.BLAST_FURNACE);
        this.blastFurnace(output, "iron_blast_furnace", "gold", SmelterType.GOLD, (TagKey<Item>)Tags.Items.INGOTS_GOLD, (ItemLike)ISItems.BLAST_FURNACES.get(SmelterType.IRON).get());
        this.cheapOutline(output, "gold_blast_furnace", "diamond", "blast_furnace", (Supplier<Item>)ISItems.BLAST_FURNACES.get(SmelterType.DIAMOND), (TagKey<Item>)Tags.Items.GEMS_DIAMOND, (ItemLike)ISItems.BLAST_FURNACES.get(SmelterType.GOLD).get());
        this.blastFurnace(output, "diamond_blast_furnace", "obsidian", SmelterType.OBSIDIAN, (TagKey<Item>)Tags.Items.OBSIDIANS_NORMAL, (ItemLike)ISItems.BLAST_FURNACES.get(SmelterType.DIAMOND).get());
        this.smoker(output, "smoker", "copper", SmelterType.COPPER, (TagKey<Item>)Tags.Items.INGOTS_COPPER, (ItemLike)Items.SMOKER);
        this.cheapOutline(output, "copper_smoker", "iron", "smoker", (Supplier<Item>)ISItems.SMOKERS.get(SmelterType.IRON), (TagKey<Item>)Tags.Items.INGOTS_IRON, (ItemLike)ISItems.SMOKERS.get(SmelterType.COPPER).get());
        this.smoker(output, "smoker", "iron", SmelterType.IRON, (TagKey<Item>)Tags.Items.INGOTS_IRON, (ItemLike)Items.SMOKER);
        this.smoker(output, "iron_smoker", "gold", SmelterType.GOLD, (TagKey<Item>)Tags.Items.INGOTS_GOLD, (ItemLike)ISItems.SMOKERS.get(SmelterType.IRON).get());
        this.cheapOutline(output, "gold_smoker", "diamond", "smoker", (Supplier<Item>)ISItems.SMOKERS.get(SmelterType.DIAMOND), (TagKey<Item>)Tags.Items.GEMS_DIAMOND, (ItemLike)ISItems.SMOKERS.get(SmelterType.GOLD).get());
        this.smoker(output, "diamond_smoker", "obsidian", SmelterType.OBSIDIAN, (TagKey<Item>)Tags.Items.OBSIDIANS_NORMAL, (ItemLike)ISItems.SMOKERS.get(SmelterType.DIAMOND).get());
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ISItems.UPGRADES.get(Pair.of((Object)SmelterType.COPPER, Optional.empty())).get())).define(Character.valueOf('I'), Tags.Items.INGOTS_COPPER).define(Character.valueOf('S'), Tags.Items.COBBLESTONES).pattern("III").pattern("ISI").pattern("III").unlockedBy("has_copper", ISRecipesProvider.has((TagKey)Tags.Items.INGOTS_COPPER)).unlockedBy("has_furnace", ISRecipesProvider.has((TagKey)Tags.Items.PLAYER_WORKSTATIONS_FURNACES)).save(output, ISConstants.rl("stone_to_copper_upgrade"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ISItems.UPGRADES.get(Pair.of((Object)SmelterType.IRON, Optional.empty())).get())).define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).define(Character.valueOf('S'), Tags.Items.COBBLESTONES).pattern("III").pattern("ISI").pattern("III").unlockedBy("has_iron", ISRecipesProvider.has((TagKey)Tags.Items.INGOTS_IRON)).unlockedBy("has_furnace", ISRecipesProvider.has((TagKey)Tags.Items.PLAYER_WORKSTATIONS_FURNACES)).save(output, ISConstants.rl("stone_to_iron_upgrade"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ISItems.UPGRADES.get(Pair.of((Object)SmelterType.IRON, Optional.of(SmelterType.COPPER))).get())).define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).define(Character.valueOf('S'), Tags.Items.COBBLESTONES).define(Character.valueOf('G'), Tags.Items.GLASS_BLOCKS).pattern("III").pattern("GSG").pattern("III").unlockedBy("has_iron", ISRecipesProvider.has((TagKey)Tags.Items.INGOTS_IRON)).unlockedBy("has_furnace", ISRecipesProvider.has((TagKey)Tags.Items.PLAYER_WORKSTATIONS_FURNACES)).save(output, ISConstants.rl("copper_to_iron_upgrade"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ISItems.UPGRADES.get(Pair.of((Object)SmelterType.GOLD, Optional.of(SmelterType.IRON))).get())).define(Character.valueOf('I'), Tags.Items.INGOTS_GOLD).define(Character.valueOf('S'), Tags.Items.COBBLESTONES).pattern("III").pattern("ISI").pattern("III").unlockedBy("has_gold", ISRecipesProvider.has((TagKey)Tags.Items.INGOTS_GOLD)).unlockedBy("has_furnace", ISRecipesProvider.has((TagKey)Tags.Items.PLAYER_WORKSTATIONS_FURNACES)).save(output, ISConstants.rl("iron_to_gold_upgrade"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ISItems.UPGRADES.get(Pair.of((Object)SmelterType.DIAMOND, Optional.of(SmelterType.GOLD))).get())).define(Character.valueOf('I'), Tags.Items.GEMS_DIAMOND).define(Character.valueOf('S'), Tags.Items.COBBLESTONES).define(Character.valueOf('G'), Tags.Items.GLASS_BLOCKS).pattern("III").pattern("GSG").pattern("III").unlockedBy("has_diamond", ISRecipesProvider.has((TagKey)Tags.Items.GEMS_DIAMOND)).unlockedBy("has_furnace", ISRecipesProvider.has((TagKey)Tags.Items.PLAYER_WORKSTATIONS_FURNACES)).save(output, ISConstants.rl("gold_to_diamond_upgrade"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ISItems.UPGRADES.get(Pair.of((Object)SmelterType.OBSIDIAN, Optional.of(SmelterType.DIAMOND))).get())).define(Character.valueOf('I'), Tags.Items.OBSIDIANS_NORMAL).define(Character.valueOf('S'), Tags.Items.COBBLESTONES).pattern("III").pattern("ISI").pattern("III").unlockedBy("has_obsidian", ISRecipesProvider.has((TagKey)Tags.Items.OBSIDIANS_NORMAL)).unlockedBy("has_furnace", ISRecipesProvider.has((TagKey)Tags.Items.PLAYER_WORKSTATIONS_FURNACES)).save(output, ISConstants.rl("diamond_to_obsidian_upgrade"));
    }

    private void furnace(RecipeOutput recipeOutput, String from, String to, SmelterType output, TagKey<Item> ingot, ItemLike input) {
        this.outline(recipeOutput, from, to, "furnace", (Supplier<Item>)ISItems.FURNACES.get(output), ingot, input);
    }

    private void blastFurnace(RecipeOutput recipeOutput, String from, String to, SmelterType output, TagKey<Item> ingot, ItemLike input) {
        this.outline(recipeOutput, from, to, "blast_furnace", (Supplier<Item>)ISItems.BLAST_FURNACES.get(output), ingot, input);
    }

    private void smoker(RecipeOutput recipeOutput, String from, String to, SmelterType output, TagKey<Item> ingot, ItemLike input) {
        this.outline(recipeOutput, from, to, "smoker", (Supplier<Item>)ISItems.SMOKERS.get(output), ingot, input);
    }

    private void outline(RecipeOutput recipeOutput, String from, String to, String type, Supplier<Item> output, TagKey<Item> ingot, ItemLike input) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)output.get())).define(Character.valueOf('O'), ingot).define(Character.valueOf('I'), input).pattern("OOO").pattern("OIO").pattern("OOO").unlockedBy("has_" + to, ISRecipesProvider.has(ingot)).save(recipeOutput, ISConstants.rl(from + "_to_" + to + "_" + type));
    }

    private void cheapOutline(RecipeOutput recipeOutput, String from, String to, String type, Supplier<Item> output, TagKey<Item> ingot, ItemLike input) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)output.get())).define(Character.valueOf('O'), ingot).define(Character.valueOf('G'), Tags.Items.GLASS_BLOCKS).define(Character.valueOf('I'), input).pattern("OOO").pattern("GIG").pattern("OOO").unlockedBy("has_" + to, ISRecipesProvider.has(ingot)).save(recipeOutput, ISConstants.rl(from + "_to_" + to + "_" + type));
    }
}

