/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.ironsmelters.block;

import com.blamejared.ironsmelters.api.SmelterType;
import com.blamejared.ironsmelters.block.ISBlastFurnaceBlock;
import com.blamejared.ironsmelters.block.ISFurnaceBlock;
import com.blamejared.ironsmelters.block.ISSmokerBlock;
import com.blamejared.ironsmelters.platform.IRegister;
import com.blamejared.ironsmelters.registry.RegistrationProvider;
import com.blamejared.ironsmelters.registry.RegistryObject;
import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;

@AutoService(value={IRegister.class})
public class ISBlocks
implements IRegister {
    public static final RegistrationProvider<Block> BLOCKS = RegistrationProvider.get(Registries.BLOCK, "ironsmelters");
    public static final Map<SmelterType, RegistryObject<Block>> FURNACES = (Map)Util.make(() -> {
        ImmutableMap.Builder map = ImmutableMap.builder();
        for (SmelterType smelterType : SmelterType.ALL.values()) {
            map.put((Object)smelterType, BLOCKS.block(smelterType.id().getPath() + "_furnace", properties -> new ISFurnaceBlock((BlockBehaviour.Properties)properties, smelterType), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.FURNACE)));
        }
        return map.build();
    });
    public static final Map<SmelterType, RegistryObject<Block>> BLAST_FURNACES = (Map)Util.make(() -> {
        ImmutableMap.Builder map = ImmutableMap.builder();
        for (SmelterType smelterType : SmelterType.ALL.values()) {
            map.put((Object)smelterType, BLOCKS.block(smelterType.id().getPath() + "_blast_furnace", properties -> new ISBlastFurnaceBlock((BlockBehaviour.Properties)properties, smelterType), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BLAST_FURNACE)));
        }
        return map.build();
    });
    public static final Map<SmelterType, RegistryObject<Block>> SMOKER = (Map)Util.make(() -> {
        ImmutableMap.Builder map = ImmutableMap.builder();
        for (SmelterType smelterType : SmelterType.ALL.values()) {
            map.put((Object)smelterType, BLOCKS.block(smelterType.id().getPath() + "_smoker", properties -> new ISSmokerBlock((BlockBehaviour.Properties)properties, smelterType), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SMOKER)));
        }
        return map.build();
    });
}

