/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.ironsmelters.api;

import com.blamejared.ironsmelters.ISConstants;
import com.blamejared.ironsmelters.config.SmelterConfig;
import com.mojang.serialization.Codec;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public record SmelterType(ResourceLocation id, String displayName, Supplier<SmelterConfig> config, Map<String, Optional<SmelterType>> upgradeFrom) {
    private static final Map<ResourceLocation, SmelterType> _ALL = new LinkedHashMap<ResourceLocation, SmelterType>();
    public static final Map<ResourceLocation, SmelterType> ALL = Collections.unmodifiableMap(_ALL);
    public static final SmelterType COPPER = new SmelterType(ISConstants.rl("copper"), "Copper", () -> ISConstants.CONFIG.vanilla.copper, Map.of("stone", Optional.empty()));
    public static final SmelterType IRON = new SmelterType(ISConstants.rl("iron"), "Iron", () -> ISConstants.CONFIG.vanilla.iron, Map.of("stone", Optional.empty(), "copper", Optional.of(COPPER)));
    public static final SmelterType GOLD = new SmelterType(ISConstants.rl("gold"), "Gold", () -> ISConstants.CONFIG.vanilla.gold, Map.of("iron", Optional.of(IRON)));
    public static final SmelterType DIAMOND = new SmelterType(ISConstants.rl("diamond"), "Diamond", () -> ISConstants.CONFIG.vanilla.diamond, Map.of("gold", Optional.of(GOLD)));
    public static final SmelterType OBSIDIAN = new SmelterType(ISConstants.rl("obsidian"), "Obsidian", () -> ISConstants.CONFIG.vanilla.obsidian, Map.of("obsidian", Optional.of(DIAMOND)));
    public static final Codec<SmelterType> CODEC = ResourceLocation.CODEC.xmap(ALL::get, SmelterType::id);

    public SmelterType(ResourceLocation id, String displayName, Supplier<SmelterConfig> config, Map<String, Optional<SmelterType>> upgradeFrom) {
        this.id = id;
        this.displayName = displayName;
        this.config = config;
        this.upgradeFrom = upgradeFrom;
        _ALL.put(id, this);
    }

    public MutableComponent displayComponent() {
        return Component.translatable((String)("ironsmelters.smeltertype." + String.valueOf(this.id())));
    }
}

