package com.blamejared.ironsmelters.block;

import com.blamejared.ironsmelters.api.SmelterType;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2363;
import net.minecraft.class_2561;

public abstract class ISAbstractFurnaceBlock extends class_2363 {
    
    private final SmelterType smelterType;
    private final Type type;
    
    protected ISAbstractFurnaceBlock(class_2251 properties, SmelterType smelterType, Type type) {
        
        super(properties);
        this.smelterType = smelterType;
        this.type = type;
    }
    
    @Override
    public void method_9568(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltipComponents, class_1836 tooltipFlag) {
        
        super.method_9568(stack, context, tooltipComponents, tooltipFlag);
        tooltipComponents.add(class_2561.method_43470("Smelts items " + this.smelterType.config()
                .get()
                .furnaceMultiplier() + "x times faster than a Furnace.").method_27692(class_124.field_1080));
    }
    
    public SmelterType smelterType() {
        
        return smelterType;
    }
    
    public Type type() {
        
        return type;
    }
    
    public enum Type {
        FURNACE,
        BLAST_FURNACE,
        SMOKER
    }
    
}
