/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.ironsmelters.component;

import com.blamejared.ironsmelters.Util;
import com.blamejared.ironsmelters.api.SmelterType;
import com.blamejared.ironsmelters.block.ISAbstractFurnaceBlock;
import com.blamejared.ironsmelters.block.ISBlocks;
import com.blamejared.ironsmelters.block.entity.AbstractISBlockEntity;
import com.blamejared.ironsmelters.registry.RegistryObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipProvider;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public record Upgrade(Optional<SmelterType> from, SmelterType to, boolean keepData) implements TooltipProvider
{
    public static final Predicate<BlockState> PREDICATE = block -> block.getBlock() == Blocks.FURNACE || block.getBlock() == Blocks.SMOKER || block.getBlock() == Blocks.BLAST_FURNACE;
    public static final Codec<Upgrade> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)SmelterType.CODEC.optionalFieldOf("from").forGetter(Upgrade::from), (App)SmelterType.CODEC.fieldOf("to").forGetter(Upgrade::to), (App)Codec.BOOL.optionalFieldOf("keep_data", (Object)true).forGetter(Upgrade::keepData)).apply((Applicative)instance, Upgrade::new));

    public boolean matches(BlockState state) {
        Block block = state.getBlock();
        if (block instanceof ISAbstractFurnaceBlock) {
            ISAbstractFurnaceBlock isafb = (ISAbstractFurnaceBlock)block;
            return this.from().filter(type -> type == isafb.smelterType()).isPresent();
        }
        return this.from.isEmpty() && PREDICATE.test(state);
    }

    public boolean upgrade(ServerLevel level, BlockState blockState, BlockPos pos) {
        BlockEntity blockEntity;
        ISAbstractFurnaceBlock.Type type;
        Block block = blockState.getBlock();
        if (block instanceof ISAbstractFurnaceBlock) {
            ISAbstractFurnaceBlock isafb = (ISAbstractFurnaceBlock)block;
            type = isafb.type();
        } else if (blockState.getBlock() == Blocks.FURNACE) {
            type = ISAbstractFurnaceBlock.Type.FURNACE;
        } else if (blockState.getBlock() == Blocks.BLAST_FURNACE) {
            type = ISAbstractFurnaceBlock.Type.BLAST_FURNACE;
        } else if (blockState.getBlock() == Blocks.SMOKER) {
            type = ISAbstractFurnaceBlock.Type.SMOKER;
        } else {
            return false;
        }
        Map<Object, Object> map = Collections.emptyMap();
        switch (type) {
            case FURNACE: {
                map = ISBlocks.FURNACES;
                break;
            }
            case BLAST_FURNACE: {
                map = ISBlocks.BLAST_FURNACES;
                break;
            }
            case SMOKER: {
                map = ISBlocks.SMOKER;
            }
        }
        BlockState newState = ((Block)((RegistryObject)map.get(this.to())).get()).defaultBlockState();
        if (this.keepData()) {
            for (Map.Entry entry : blockState.getValues().entrySet()) {
                newState = (BlockState)newState.setValue((Property)entry.getKey(), (Comparable)Util.uncheck(entry.getValue()));
            }
        }
        BlockEntity oldEntity = level.getBlockEntity(pos);
        RegistryAccess registryAccess = level.registryAccess();
        CompoundTag save = oldEntity != null ? oldEntity.saveWithoutMetadata((HolderLookup.Provider)registryAccess) : null;
        level.removeBlockEntity(pos);
        level.setBlock(pos, newState, 3);
        if (this.keepData() && (blockEntity = level.getBlockEntity(pos)) instanceof AbstractISBlockEntity) {
            AbstractISBlockEntity aisbe = (AbstractISBlockEntity)blockEntity;
            if (save != null) {
                aisbe.loadWithComponents(save, (HolderLookup.Provider)registryAccess);
            }
        }
        return true;
    }

    public void addToTooltip(Item.TooltipContext context, Consumer<Component> tooltipAdder, TooltipFlag tooltipFlag) {
        tooltipAdder.accept((Component)Component.literal((String)"test"));
    }
}

