/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.iceandfiretweaker.handler;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.CraftTweakerConstants;
import com.blamejared.crafttweaker.api.action.base.IAction;
import com.blamejared.crafttweaker.api.action.recipe.ActionAddRecipe;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import com.github.alexthe666.iceandfire.entity.DragonType;
import com.github.alexthe666.iceandfire.recipe.DragonForgeRecipe;
import com.github.alexthe666.iceandfire.recipe.IafRecipeRegistry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.iceandfire.recipe.DragonForgeRecipeManager")
@Document(value="mods/IceAndFire/recipe/manager/DragonForgeRecipeManager")
public class DragonForge
implements IRecipeManager<DragonForgeRecipe> {
    @ZenCodeType.Method
    public void addFireRecipe(String name, IItemStack output, IIngredient input, IIngredient blood, int cookTime) {
        this.addRecipe(name, DragonType.FIRE.getName(), output, input, blood, cookTime);
    }

    @ZenCodeType.Method
    public void addIceRecipe(String name, IItemStack output, IIngredient input, IIngredient blood, int cookTime) {
        this.addRecipe(name, DragonType.ICE.getName(), output, input, blood, cookTime);
    }

    @ZenCodeType.Method
    public void addLightningRecipe(String name, IItemStack output, IIngredient input, IIngredient blood, int cookTime) {
        this.addRecipe(name, DragonType.LIGHTNING.getName(), output, input, blood, cookTime);
    }

    public void addRecipe(String name, String dragonType, IItemStack output, IIngredient input, IIngredient blood, int cookTime) {
        ResourceLocation id = CraftTweakerConstants.rl((String)this.fixRecipeName(name));
        CraftTweakerAPI.apply((IAction)new ActionAddRecipe((IRecipeManager)this, (Recipe)new DragonForgeRecipe(id, input.asVanillaIngredient(), blood.asVanillaIngredient(), output.getInternal(), dragonType, cookTime)));
    }

    public RecipeType<DragonForgeRecipe> getRecipeType() {
        return (RecipeType)IafRecipeRegistry.DRAGON_FORGE_TYPE.get();
    }
}

