package com.blamejared.darkrooms.mixin;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.class_1944;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2372;
import net.minecraft.class_2500;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_5819;

@Mixin(class_2372.class)
public abstract class MixinGrassBlock extends class_2500 {
    
    protected MixinGrassBlock(class_2251 $$0) {
        
        super($$0);
    }
    
    @Unique
    private final Set<class_2338> darkrooms$toDestroy = new HashSet<>();
    
    @ModifyArg(method = "performBonemeal", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/level/levelgen/placement/PlacedFeature;place(Lnet/minecraft/world/level/WorldGenLevel;Lnet/minecraft/world/level/chunk/ChunkGenerator;Lnet/minecraft/util/RandomSource;Lnet/minecraft/core/BlockPos;)Z"))
    public class_2338 darkrooms$capturePos(class_2338 pos) {
        
        darkrooms$toDestroy.add(pos);
        return pos;
    }
    
    @Inject(method = "performBonemeal", at = @At(value = "TAIL"))
    public void darkrooms$destroyBlocks(class_3218 level, class_5819 $$1, class_2338 $$2, class_2680 $$3, CallbackInfo ci) {
        
        Iterator<class_2338> iterator = darkrooms$toDestroy.iterator();
        while(iterator.hasNext()) {
            class_2338 blockPos = iterator.next();
            int brightness = Math.max(level.method_8314(class_1944.field_9282, blockPos), level.method_8314(class_1944.field_9284, blockPos));
            if(brightness == 0) {
                class_2680 state = level.method_8320(blockPos);
                class_2248.method_9497(state, level, blockPos);
                level.method_8650(blockPos, false);
            }
            iterator.remove();
        }
    }
    
}
