/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.createtweaker.recipe.manager;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.action.base.IAction;
import com.blamejared.crafttweaker.api.action.recipe.ActionAddRecipe;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker.impl.helper.AccessibleElementsProvider;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.content.processing.sequenced.SequencedAssemblyRecipe;
import com.simibubi.create.content.processing.sequenced.SequencedAssemblyRecipeBuilder;
import com.simibubi.create.content.processing.sequenced.SequencedAssemblyRecipeSerializer;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.create.SequencedAssemblyManager")
@Document(value="mods/createtweaker/SequencedAssemblyManager")
public class SequencedAssemblyManager
implements IRecipeManager<SequencedAssemblyRecipe> {
    @ZenCodeType.Method
    public SequencedAssemblyRecipeBuilder builder(String name) {
        return new SequencedAssemblyRecipeBuilder(new ResourceLocation("crafttweaker", name));
    }

    @ZenCodeType.Method
    public void registerRecipe(String name, Consumer<SequencedAssemblyRecipeBuilder> recipeBuilder) {
        name = this.fixRecipeName(name);
        ResourceLocation recipeId = new ResourceLocation("crafttweaker", name);
        SequencedAssemblyRecipeBuilder builder = new SequencedAssemblyRecipeBuilder(recipeId);
        recipeBuilder.accept(builder);
        this.addInternal(builder);
    }

    @ZenCodeType.Method
    public void addRecipe(SequencedAssemblyRecipeBuilder builder) {
        this.addInternal(builder);
    }

    private void addInternal(SequencedAssemblyRecipeBuilder builder) {
        SequencedAssemblyRecipe recipe = builder.build();
        this.precheck(recipe);
        builder.build(iFinishedRecipe -> {
            SequencedAssemblyRecipe seqRecipe = (SequencedAssemblyRecipe)iFinishedRecipe.m_6637_().m_6729_(new ResourceLocation("crafttweaker", iFinishedRecipe.m_6445_().m_135815_()), iFinishedRecipe.m_125966_());
            CraftTweakerAPI.apply((IAction)new ActionAddRecipe((IRecipeManager)this, (Recipe)seqRecipe));
        });
    }

    private void precheck(SequencedAssemblyRecipe recipe) {
        if (recipe.getTransitionalItem().m_41619_()) {
            throw new IllegalArgumentException("Error while adding Sequenced Assembly Recipe! The `transitionTo` item is not provided or is air! transitionTo: " + recipe.getTransitionalItem());
        }
        try {
            if (((ItemStack)AccessibleElementsProvider.get().registryAccess(arg_0 -> ((SequencedAssemblyRecipe)recipe).m_8043_(arg_0))).m_41619_()) {
                throw new IllegalArgumentException("Error while adding Sequenced Assembly Recipe! The `output` is not provided or is air! output: " + recipe.getTransitionalItem());
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Error while adding Sequenced Assembly Recipe! The `output` is not provided or is air! output: " + recipe.getTransitionalItem());
        }
        if (recipe.getIngredient() == null) {
            throw new IllegalArgumentException("Error while adding Sequenced Assembly Recipe! The `inputs` is not provided! inputs: " + recipe.getIngredient());
        }
        if (recipe.getSequence().isEmpty()) {
            throw new IllegalArgumentException("Error while adding Sequenced Assembly Recipe! No Steps have been provided!");
        }
    }

    public RecipeType<SequencedAssemblyRecipe> getRecipeType() {
        return AllRecipeTypes.SEQUENCED_ASSEMBLY.getType();
    }

    public SequencedAssemblyRecipeSerializer getSerializer() {
        return (SequencedAssemblyRecipeSerializer)AllRecipeTypes.SEQUENCED_ASSEMBLY.getSerializer();
    }
}

