/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.createtweaker.recipe.manager;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.action.base.IAction;
import com.blamejared.crafttweaker.api.action.recipe.ActionAddRecipe;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.content.kinetics.crafter.MechanicalCraftingRecipe;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.create.MechanicalCrafterManager")
@Document(value="mods/createtweaker/MechanicalCrafterManager")
public class MechanicalCrafterManager
implements IRecipeManager<MechanicalCraftingRecipe> {
    @ZenCodeType.Method
    public void addRecipe(String name, IItemStack output, IIngredient[][] ingredients) {
        this.addInternal(name, output, ingredients, false);
    }

    @ZenCodeType.Method
    public void addMirroredRecipe(String name, IItemStack output, IIngredient[][] ingredients) {
        this.addInternal(name, output, ingredients, true);
    }

    private void addInternal(String name, IItemStack output, IIngredient[][] ingredients, boolean mirrored) {
        name = this.fixRecipeName(name);
        int width = ingredients[0].length;
        for (IIngredient[] value : ingredients) {
            if (value.length == width) continue;
            throw new IllegalArgumentException("Create Mechanical Crafter IIngredient array needs to have the same length for all entries (the arrays need to contain the exact same amount of ingredients, use <item:minecraft:air> to pad the arrays out!)");
        }
        ResourceLocation resourceLocation = new ResourceLocation("crafttweaker", name);
        NonNullList ingredientList = NonNullList.m_122779_();
        IIngredient[][] iIngredientArray = ingredients;
        int value = iIngredientArray.length;
        for (int i = 0; i < value; ++i) {
            IIngredient[] iIngredients;
            for (IIngredient iIngredient : iIngredients = iIngredientArray[i]) {
                ingredientList.add((Object)iIngredient.asVanillaIngredient());
            }
        }
        NonNullList list = NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])((Ingredient[])ingredientList.toArray((Object[])new Ingredient[0])));
        MechanicalCraftingRecipe recipe = new MechanicalCraftingRecipe(resourceLocation, "", width, ingredients.length, list, output.getInternal(), mirrored);
        CraftTweakerAPI.apply((IAction)new ActionAddRecipe((IRecipeManager)this, (Recipe)recipe));
    }

    public RecipeType<MechanicalCraftingRecipe> getRecipeType() {
        return AllRecipeTypes.MECHANICAL_CRAFTING.getType();
    }
}

