/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.createtweaker.recipe.manager;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.util.random.Percentaged;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import com.blamejared.createtweaker.recipe.manager.base.IProcessingRecipeManager;
import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.content.kinetics.deployer.DeployerApplicationRecipe;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.create.DeployerApplicationManager")
@Document(value="mods/createtweaker/DeployerApplicationManager")
public class DeployerApplicationManager
implements IProcessingRecipeManager<DeployerApplicationRecipe> {
    @ZenCodeType.Method
    public void addRecipe(String name, IIngredient processedItem, IIngredient heldItem, Percentaged<IItemStack>[] outputs, @ZenCodeType.OptionalBoolean boolean keepHeldItem) {
        if (outputs.length > 2) {
            throw new IllegalArgumentException(String.format("Deployer recipe has more outputs (%s) than supported (2)!", outputs.length));
        }
        this.registerRecipe(name, recipeBuilder -> {
            recipeBuilder.require(processedItem.asVanillaIngredient());
            recipeBuilder.require(heldItem.asVanillaIngredient());
            if (keepHeldItem) {
                recipeBuilder.toolNotConsumed();
            }
            for (Percentaged stack : outputs) {
                recipeBuilder.output((float)stack.getPercentage(), ((IItemStack)stack.getData()).getInternal());
            }
        });
    }

    @Override
    public AllRecipeTypes getCreateRecipeType() {
        return AllRecipeTypes.DEPLOYING;
    }
}

