package com.blamejared.createtweaker.service;

import com.blamejared.crafttweaker.api.fluid.CTFluidIngredient;
import com.blamejared.crafttweaker.api.fluid.IFluidStack;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeBuilder;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_3611;
import net.minecraft.class_6862;

public interface PlatformService {
    
    long getRequiredAmount(FluidIngredient ingredient);
    <T extends ProcessingRecipe<?>> boolean doFluidIngredientsConflict(T first, T second);
    
    boolean testFluidIngredient(FluidIngredient ingredient, IFluidStack stack);
    
    
    <T extends ProcessingRecipe<? extends class_1263>> ProcessingRecipeBuilder<T> withFluidOutputs(ProcessingRecipeBuilder<T> builder, List<IFluidStack> fluidOutputs);
    
    ProcessingRecipeBuilder<ProcessingRecipe<class_1263>> output(ProcessingRecipeBuilder<?> builder, IFluidStack output);
    
    ProcessingRecipeBuilder<ProcessingRecipe<class_1263>> withFluidOutputs(ProcessingRecipeBuilder<ProcessingRecipe<class_1263>> builder, IFluidStack... outputs);
    
    List<IFluidStack> getRecipeFluidResults(ProcessingRecipe<?> recipe);
    
    List<IFluidStack> getMatchingFluidStacks(FluidIngredient ingredient);
    
    FluidIngredient fromFluidStack(IFluidStack stack);
    
    FluidIngredient fromTag(class_6862<class_3611> tag, int amount);
    
    CTFluidIngredient mapFluidIngredientsToCT(FluidIngredient ingredient);
    
    
}
