package com.blamejared.createtweaker.recipe.handler;

import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.recipe.MirrorAxis;
import com.blamejared.crafttweaker.api.recipe.component.BuiltinRecipeComponents;
import com.blamejared.crafttweaker.api.recipe.component.IDecomposedRecipe;
import com.blamejared.crafttweaker.api.recipe.handler.IRecipeHandler;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker.api.util.StringUtil;
import com.blamejared.crafttweaker.impl.helper.AccessibleElementsProvider;
import com.blamejared.crafttweaker.platform.Services;
import com.mojang.datafixers.util.Pair;
import com.simibubi.create.content.kinetics.crafter.MechanicalCraftingRecipe;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_2371;
import net.minecraft.class_2960;

@IRecipeHandler.For(MechanicalCraftingRecipe.class)
public class MechanicalCraftingRecipeHandler implements IRecipeHandler<MechanicalCraftingRecipe> {
    
    @Override
    public String dumpToCommandString(IRecipeManager iRecipeManager, MechanicalCraftingRecipe recipe) {
        
        final class_2371<class_1856> ingredients = recipe.method_8117();
        return String.format(
                "<recipetype:create:mechanical_crafting>.addRecipe(%s, %s, %s);",
                StringUtil.quoteAndEscape(recipe.method_8114()),
                IItemStack.of(AccessibleElementsProvider.get().registryAccess(recipe::method_8110)).getCommandString(),
                IntStream.range(0, recipe.method_8158())
                        .mapToObj(y -> IntStream.range(0, recipe.method_8150())
                                .mapToObj(x -> ingredients.get(y * recipe.method_8150() + x))
                                .map(IIngredient::fromIngredient)
                                .map(IIngredient::getCommandString)
                                .collect(Collectors.joining(", ", "[", "]")))
                        .collect(Collectors.joining(", ", "[", "]"))
        );
    }
    
    @Override
    public <U extends class_1860<?>> boolean doesConflict(IRecipeManager<? super MechanicalCraftingRecipe> manager, MechanicalCraftingRecipe firstRecipe, U secondRecipe) {
        
        return Services.PLATFORM.doCraftingTableRecipesConflict(manager, firstRecipe, secondRecipe);
    }
    
    @Override
    public Optional<IDecomposedRecipe> decompose(IRecipeManager<? super MechanicalCraftingRecipe> manager, MechanicalCraftingRecipe recipe) {
        
        final List<IIngredient> ingredients = recipe.method_8117().stream()
                .map(IIngredient::fromIngredient)
                .toList();
        final IDecomposedRecipe decomposedRecipe = IDecomposedRecipe.builder()
                .with(BuiltinRecipeComponents.Metadata.GROUP, recipe.method_8112())
                .with(BuiltinRecipeComponents.Metadata.SHAPE_SIZE_2D, Pair.of(recipe.method_8150(), recipe.method_8158()))
                .with(BuiltinRecipeComponents.Input.INGREDIENTS, ingredients)
                .with(BuiltinRecipeComponents.Output.ITEMS, IItemStack.of(AccessibleElementsProvider.get().registryAccess(recipe::method_8110)))
                .with(BuiltinRecipeComponents.Metadata.MIRROR_AXIS, recipe.acceptsMirrored() ? MirrorAxis.HORIZONTAL : MirrorAxis.NONE)
                .build();
        return Optional.of(decomposedRecipe);
    }
    
    @Override
    public Optional<MechanicalCraftingRecipe> recompose(IRecipeManager<? super MechanicalCraftingRecipe> manager, class_2960 name, IDecomposedRecipe recipe) {
        
        final String group = recipe.getOrThrowSingle(BuiltinRecipeComponents.Metadata.GROUP);
        final Pair<Integer, Integer> size = recipe.getOrThrowSingle(BuiltinRecipeComponents.Metadata.SHAPE_SIZE_2D);
        final List<IIngredient> ingredients = recipe.getOrThrow(BuiltinRecipeComponents.Input.INGREDIENTS);
        final IItemStack output = recipe.getOrThrowSingle(BuiltinRecipeComponents.Output.ITEMS);
        final boolean acceptsMirrored = recipe.getOrThrowSingle(BuiltinRecipeComponents.Metadata.MIRROR_AXIS)
                .isMirrored();
        
        final int width = size.getFirst();
        final int height = size.getSecond();
        
        if(width <= 0 || height <= 0) {
            throw new IllegalArgumentException("Invalid shape size: bounds must be positive but got " + size);
        }
        if(width * height != ingredients.size()) {
            throw new IllegalArgumentException("Invalid shape size: incompatible with ingredients, got " + size + " with " + ingredients.size());
        }
        if(output.isEmpty()) {
            throw new IllegalArgumentException("Invalid output: empty item");
        }
        
        final class_2371<class_1856> recipeIngredients = ingredients.stream()
                .map(IIngredient::asVanillaIngredient)
                .collect(class_2371::method_10211, class_2371::add, class_2371::addAll);
        return Optional.of(new MechanicalCraftingRecipe(name, group, width, height, recipeIngredients, output.getInternal(), acceptsMirrored));
    }
    
}
