package com.blamejared.createtweaker.recipe.handler;

import com.blamejared.crafttweaker.api.fluid.IFluidStack;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.recipe.handler.IRecipeHandler;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.createtweaker.CreateTweakerHelper;
import com.blamejared.createtweaker.service.Services;
import com.simibubi.create.content.fluids.transfer.EmptyingRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeBuilder;
import java.util.List;
import net.minecraft.class_1860;

@IRecipeHandler.For(EmptyingRecipe.class)
public class EmptyingRecipeHandler implements IProcessingRecipeHandler<EmptyingRecipe> {
    
    @Override
    public String dumpToCommandString(IRecipeManager iRecipeManager, EmptyingRecipe recipe) {
        
        List<IFluidStack> fluidResults = Services.PLATFORM.getRecipeFluidResults(recipe);
        return String.format("<recipetype:create:emptying>.addRecipe(\"%s\", %s, %s, %s);",
                recipe.method_8114(),
                CreateTweakerHelper.mapProcessingResult(recipe.getRollableResults().get(0)).getCommandString(),
                (fluidResults.isEmpty() ? IFluidStack.empty() : fluidResults.get(0)).getCommandString(),
                IIngredient.fromIngredient(recipe.method_8117().get(0)).getCommandString()
        );
    }
    
    @Override
    public boolean isGoodRecipe(class_1860<?> recipe) {
        
        return recipe instanceof EmptyingRecipe;
    }
    
    @Override
    public ProcessingRecipeBuilder.ProcessingRecipeFactory<EmptyingRecipe> factory() {
        
        return EmptyingRecipe::new;
    }
    
}
