package com.blamejared.createtweaker.recipe.handler;

import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.recipe.component.IDecomposedRecipe;
import com.blamejared.crafttweaker.api.recipe.handler.IRecipeHandler;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker.api.util.random.Percentaged;
import com.blamejared.createtweaker.CreateTweaker;
import com.blamejared.createtweaker.CreateTweakerHelper;
import com.simibubi.create.content.kinetics.crusher.CrushingRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeBuilder;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.class_1860;

@IRecipeHandler.For(CrushingRecipe.class)
public class CrushingRecipeHandler implements IProcessingRecipeHandler<CrushingRecipe> {
    
    @Override
    public String dumpToCommandString(IRecipeManager iRecipeManager, CrushingRecipe recipe) {
        
        return String.format("<recipetype:create:crushing>.addRecipe(\"%s\", [%s], %s, %s);",
                recipe.method_8114(),
                recipe.getRollableResults()
                        .stream()
                        .map(CreateTweakerHelper::mapProcessingResult)
                        .map(Percentaged::getCommandString)
                        .collect(Collectors.joining(", ")),
                IIngredient.fromIngredient(recipe.method_8117().get(0)).getCommandString(),
                recipe.getProcessingDuration()
        );
        
    }
    
    @Override
    public boolean isGoodRecipe(class_1860<?> recipe) {
        
        return recipe instanceof CrushingRecipe;
    }
    
    @Override
    public ProcessingRecipeBuilder.ProcessingRecipeFactory<CrushingRecipe> factory() {
        
        return CrushingRecipe::new;
    }
    
}
