package com.blamejared.createtweaker.recipe.handler;

import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.recipe.handler.IRecipeHandler;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker.api.util.random.Percentaged;
import com.blamejared.createtweaker.CreateTweaker;
import com.blamejared.createtweaker.CreateTweakerHelper;
import com.simibubi.create.content.kinetics.deployer.ManualApplicationRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeBuilder;
import java.util.stream.Collectors;
import net.minecraft.class_1860;

@IRecipeHandler.For(ManualApplicationRecipe.class)
public class ItemApplicationRecipeHandler implements IProcessingRecipeHandler<ManualApplicationRecipe> {
    
    @Override
    public String dumpToCommandString(IRecipeManager iRecipeManager, ManualApplicationRecipe recipe) {
        
        return String.format("<recipetype:create:item_application>.addRecipe(\"%s\", [%s], %s, %s);",
                recipe.method_8114(),
                recipe.getRollableResults()
                        .stream()
                        .map(CreateTweakerHelper::mapProcessingResult)
                        .map(Percentaged::getCommandString)
                        .collect(Collectors.joining(", ")),
                IIngredient.fromIngredient(recipe.getProcessedItem())
                        .getCommandString(),
                IIngredient.fromIngredient(recipe.getRequiredHeldItem())
                        .getCommandString()
        
        );
        
    }
    
    @Override
    public boolean isGoodRecipe(class_1860<?> recipe) {
        
        return recipe instanceof ManualApplicationRecipe;
    }
    
    @Override
    public ProcessingRecipeBuilder.ProcessingRecipeFactory<ManualApplicationRecipe> factory() {
        
        return ManualApplicationRecipe::new;
    }
    
}
