/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.createtweaker.recipe.handler;

import com.blamejared.crafttweaker.api.fluid.IFluidStack;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.recipe.handler.IRecipeHandler;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker.api.util.random.Percentaged;
import com.blamejared.createtweaker.CreateTweakerHelper;
import com.blamejared.createtweaker.recipe.handler.IProcessingRecipeHandler;
import com.blamejared.createtweaker.service.Services;
import com.mojang.datafixers.util.Either;
import com.simibubi.create.content.kinetics.mixer.CompactingRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeBuilder;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import net.minecraft.world.item.crafting.Recipe;

@IRecipeHandler.For(value=CompactingRecipe.class)
public class CompactingRecipeHandler
implements IProcessingRecipeHandler<CompactingRecipe> {
    public String dumpToCommandString(IRecipeManager iRecipeManager, CompactingRecipe recipe) {
        List<IFluidStack> fluidResults = Services.PLATFORM.getRecipeFluidResults((ProcessingRecipe<?>)recipe);
        Either result = !fluidResults.isEmpty() ? Either.right((Object)fluidResults.get(0)) : Either.left(recipe.getRollableResults().stream().map(CreateTweakerHelper::mapProcessingResult));
        return String.format("<recipetype:create:compacting>.addRecipe(\"%s\", <constant:create:heat_condition:%s>, [%s], [%s], [%s]);", recipe.getId(), recipe.getRequiredHeat().name().toLowerCase(Locale.ENGLISH), result.map(results -> results.map(Percentaged::getCommandString).collect(Collectors.joining(", ")), IFluidStack::getCommandString), recipe.getIngredients().stream().map(IIngredient::fromIngredient).map(IIngredient::getCommandString).collect(Collectors.joining(", ")), Services.PLATFORM.getRecipeFluidResults((ProcessingRecipe<?>)recipe).stream().map(IFluidStack::getCommandString).collect(Collectors.joining(", ")));
    }

    @Override
    public boolean isGoodRecipe(Recipe<?> recipe) {
        return recipe instanceof CompactingRecipe;
    }

    @Override
    public ProcessingRecipeBuilder.ProcessingRecipeFactory<CompactingRecipe> factory() {
        return CompactingRecipe::new;
    }
}

