/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.createtweaker.recipe.handler;

import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.recipe.MirrorAxis;
import com.blamejared.crafttweaker.api.recipe.component.BuiltinRecipeComponents;
import com.blamejared.crafttweaker.api.recipe.component.IDecomposedRecipe;
import com.blamejared.crafttweaker.api.recipe.handler.IRecipeHandler;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker.api.util.StringUtil;
import com.blamejared.crafttweaker.impl.helper.AccessibleElementsProvider;
import com.blamejared.crafttweaker.platform.Services;
import com.mojang.datafixers.util.Pair;
import com.simibubi.create.content.kinetics.crafter.MechanicalCraftingRecipe;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;

@IRecipeHandler.For(value=MechanicalCraftingRecipe.class)
public class MechanicalCraftingRecipeHandler
implements IRecipeHandler<MechanicalCraftingRecipe> {
    public String dumpToCommandString(IRecipeManager iRecipeManager, MechanicalCraftingRecipe recipe) {
        NonNullList ingredients = recipe.getIngredients();
        Object[] objectArray = new Object[3];
        objectArray[0] = StringUtil.quoteAndEscape((ResourceLocation)recipe.getId());
        objectArray[1] = IItemStack.of((ItemStack)((ItemStack)AccessibleElementsProvider.get().registryAccess(arg_0 -> ((MechanicalCraftingRecipe)recipe).getResultItem(arg_0)))).getCommandString();
        objectArray[2] = IntStream.range(0, recipe.getHeight()).mapToObj(y -> IntStream.range(0, recipe.getWidth()).mapToObj(x -> (Ingredient)ingredients.get(y * recipe.getWidth() + x)).map(IIngredient::fromIngredient).map(IIngredient::getCommandString).collect(Collectors.joining(", ", "[", "]"))).collect(Collectors.joining(", ", "[", "]"));
        return String.format("<recipetype:create:mechanical_crafting>.addRecipe(%s, %s, %s);", objectArray);
    }

    public <U extends Recipe<?>> boolean doesConflict(IRecipeManager<? super MechanicalCraftingRecipe> manager, MechanicalCraftingRecipe firstRecipe, U secondRecipe) {
        return Services.PLATFORM.doCraftingTableRecipesConflict(manager, (Recipe)firstRecipe, secondRecipe);
    }

    public Optional<IDecomposedRecipe> decompose(IRecipeManager<? super MechanicalCraftingRecipe> manager, MechanicalCraftingRecipe recipe) {
        List<IIngredient> ingredients = recipe.getIngredients().stream().map(IIngredient::fromIngredient).toList();
        IDecomposedRecipe decomposedRecipe = IDecomposedRecipe.builder().with(BuiltinRecipeComponents.Metadata.GROUP, (Object)recipe.getGroup()).with(BuiltinRecipeComponents.Metadata.SHAPE_SIZE_2D, (Object)Pair.of((Object)recipe.getWidth(), (Object)recipe.getHeight())).with(BuiltinRecipeComponents.Input.INGREDIENTS, ingredients).with(BuiltinRecipeComponents.Output.ITEMS, (Object)IItemStack.of((ItemStack)((ItemStack)AccessibleElementsProvider.get().registryAccess(arg_0 -> ((MechanicalCraftingRecipe)recipe).getResultItem(arg_0))))).with(BuiltinRecipeComponents.Metadata.MIRROR_AXIS, (Object)(recipe.acceptsMirrored() ? MirrorAxis.HORIZONTAL : MirrorAxis.NONE)).build();
        return Optional.of(decomposedRecipe);
    }

    public Optional<MechanicalCraftingRecipe> recompose(IRecipeManager<? super MechanicalCraftingRecipe> manager, ResourceLocation name, IDecomposedRecipe recipe) {
        String group = (String)recipe.getOrThrowSingle(BuiltinRecipeComponents.Metadata.GROUP);
        Pair size = (Pair)recipe.getOrThrowSingle(BuiltinRecipeComponents.Metadata.SHAPE_SIZE_2D);
        List ingredients = recipe.getOrThrow(BuiltinRecipeComponents.Input.INGREDIENTS);
        IItemStack output = (IItemStack)recipe.getOrThrowSingle(BuiltinRecipeComponents.Output.ITEMS);
        boolean acceptsMirrored = ((MirrorAxis)recipe.getOrThrowSingle(BuiltinRecipeComponents.Metadata.MIRROR_AXIS)).isMirrored();
        int width = (Integer)size.getFirst();
        int height = (Integer)size.getSecond();
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException("Invalid shape size: bounds must be positive but got " + size);
        }
        if (width * height != ingredients.size()) {
            throw new IllegalArgumentException("Invalid shape size: incompatible with ingredients, got " + size + " with " + ingredients.size());
        }
        if (output.isEmpty()) {
            throw new IllegalArgumentException("Invalid output: empty item");
        }
        NonNullList recipeIngredients = ingredients.stream().map(IIngredient::asVanillaIngredient).collect(NonNullList::create, AbstractList::add, AbstractCollection::addAll);
        return Optional.of(new MechanicalCraftingRecipe(name, group, width, height, recipeIngredients, output.getInternal(), acceptsMirrored));
    }
}

