/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.createtweaker.handlers;

import com.blamejared.crafttweaker.api.fluid.IFluidStack;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.recipe.component.BuiltinForgeRecipeComponents;
import com.blamejared.crafttweaker.api.recipe.component.BuiltinRecipeComponents;
import com.blamejared.crafttweaker.api.recipe.component.IDecomposedRecipe;
import com.blamejared.crafttweaker.api.recipe.handler.IRecipeHandler;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker.api.util.IngredientUtil;
import com.blamejared.createtweaker.CreateTweaker;
import com.blamejared.createtweaker.recipe.replacement.CreateTweakerRecipeComponents;
import com.simibubi.create.content.processing.recipe.HeatCondition;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeBuilder;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraftforge.fluids.FluidStack;

public interface IProcessingRecipeHandler<T extends ProcessingRecipe<? extends Container>>
extends IRecipeHandler<T> {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    default public <U extends Recipe<?>> boolean doesConflict(IRecipeManager<? super T> manager, T first, U secondRecipe) {
        if (!this.isGoodRecipe(secondRecipe)) return false;
        ProcessingRecipe second = (ProcessingRecipe)secondRecipe;
        if (first.m_7527_().size() != second.m_7527_().size()) return false;
        if (!first.getRequiredHeat().equals((Object)second.getRequiredHeat())) {
            return false;
        }
        if (!IngredientUtil.doIngredientsConflict((List)first.m_7527_(), (List)second.m_7527_())) return false;
        if (!IngredientUtil.doIngredientsConflict((List)first.getFluidIngredients(), (List)second.getFluidIngredients(), FluidIngredient.EMPTY::equals, fluidIngredient -> (FluidStack[])fluidIngredient.getMatchingFluidStacks().toArray(FluidStack[]::new), FluidStack::containsFluid)) return false;
        return true;
    }

    default public Optional<IDecomposedRecipe> decompose(IRecipeManager<? super T> manager, T recipe) {
        return Optional.of(IDecomposedRecipe.builder().with(BuiltinRecipeComponents.Input.INGREDIENTS, recipe.m_7527_().stream().map(IIngredient::fromIngredient).toList()).with(BuiltinRecipeComponents.Output.CHANCED_ITEMS_SINGLE, recipe.getRollableResults().stream().map(CreateTweaker::mapProcessingResult).toList()).with(BuiltinForgeRecipeComponents.Input.FLUID_INGREDIENTS, recipe.getFluidIngredients().stream().map(CreateTweaker::mapFluidIngredientsToCT).toList()).with(BuiltinForgeRecipeComponents.Output.FLUIDS, recipe.getFluidResults().stream().map(IFluidStack::of).toList()).with(BuiltinRecipeComponents.Processing.TIME, (Object)recipe.getProcessingDuration()).with(CreateTweakerRecipeComponents.Input.HEAT, (Object)recipe.getRequiredHeat()).build());
    }

    default public Optional<T> recompose(IRecipeManager<? super T> manager, ResourceLocation name, IDecomposedRecipe recipe) {
        ProcessingRecipeBuilder builder = new ProcessingRecipeBuilder(this.factory(), name);
        builder.withItemIngredients(recipe.getOrThrow(BuiltinRecipeComponents.Input.INGREDIENTS).stream().map(IIngredient::asVanillaIngredient).collect(Collectors.toCollection(NonNullList::m_122779_)));
        builder.withItemOutputs(recipe.getOrThrow(BuiltinRecipeComponents.Output.CHANCED_ITEMS_SINGLE).stream().map(CreateTweaker::mapPercentagedToProcessingOutput).collect(Collectors.toCollection(NonNullList::m_122779_)));
        builder.withFluidIngredients(recipe.getOrThrow(BuiltinForgeRecipeComponents.Input.FLUID_INGREDIENTS).stream().map(CreateTweaker::mapFluidIngredients).collect(Collectors.toCollection(NonNullList::m_122779_)));
        builder.withFluidOutputs(recipe.getOrThrow(BuiltinForgeRecipeComponents.Output.FLUIDS).stream().map(IFluidStack::getInternal).collect(Collectors.toCollection(NonNullList::m_122779_)));
        builder.duration(((Integer)recipe.getOrThrowSingle(BuiltinRecipeComponents.Processing.TIME)).intValue());
        builder.requiresHeat((HeatCondition)recipe.getOrThrowSingle(CreateTweakerRecipeComponents.Input.HEAT));
        return Optional.of(builder.build());
    }

    public boolean isGoodRecipe(Recipe<?> var1);

    public ProcessingRecipeBuilder.ProcessingRecipeFactory<T> factory();
}

