/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.ingredient;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.action.item.ActionModifyAttribute;
import com.blamejared.crafttweaker.api.action.item.ActionSetBurnTime;
import com.blamejared.crafttweaker.api.action.item.tooltip.ActionAddShiftedTooltip;
import com.blamejared.crafttweaker.api.action.item.tooltip.ActionAddTooltip;
import com.blamejared.crafttweaker.api.action.item.tooltip.ActionClearTooltip;
import com.blamejared.crafttweaker.api.action.item.tooltip.ActionModifyShiftedTooltip;
import com.blamejared.crafttweaker.api.action.item.tooltip.ActionModifyTooltip;
import com.blamejared.crafttweaker.api.action.item.tooltip.ActionRemoveRegexTooltip;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.bracket.CommandStringDisplayable;
import com.blamejared.crafttweaker.api.data.IData;
import com.blamejared.crafttweaker.api.data.MapData;
import com.blamejared.crafttweaker.api.data.converter.JSONConverter;
import com.blamejared.crafttweaker.api.ingredient.IIngredientWithAmount;
import com.blamejared.crafttweaker.api.ingredient.IngredientConverter;
import com.blamejared.crafttweaker.api.ingredient.condition.IIngredientCondition;
import com.blamejared.crafttweaker.api.ingredient.condition.type.ConditionAnyDamage;
import com.blamejared.crafttweaker.api.ingredient.condition.type.ConditionCustom;
import com.blamejared.crafttweaker.api.ingredient.condition.type.ConditionDamaged;
import com.blamejared.crafttweaker.api.ingredient.condition.type.ConditionDamagedAtLeast;
import com.blamejared.crafttweaker.api.ingredient.condition.type.ConditionDamagedAtMost;
import com.blamejared.crafttweaker.api.ingredient.transform.IIngredientTransformer;
import com.blamejared.crafttweaker.api.ingredient.transform.type.TransformCustom;
import com.blamejared.crafttweaker.api.ingredient.transform.type.TransformDamage;
import com.blamejared.crafttweaker.api.ingredient.transform.type.TransformReplace;
import com.blamejared.crafttweaker.api.ingredient.transform.type.TransformReuse;
import com.blamejared.crafttweaker.api.ingredient.type.IIngredientConditioned;
import com.blamejared.crafttweaker.api.ingredient.type.IIngredientList;
import com.blamejared.crafttweaker.api.ingredient.type.IIngredientTransformed;
import com.blamejared.crafttweaker.api.ingredient.type.IngredientWithAmount;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.item.tooltip.ITooltipFunction;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import java.util.Arrays;
import java.util.HashSet;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.ingredient.IIngredient")
@Document(value="vanilla/api/ingredient/IIngredient")
public interface IIngredient
extends CommandStringDisplayable {
    @ZenCodeType.Method
    default public boolean matches(IItemStack stack) {
        return this.matches(stack, false);
    }

    @ZenCodeType.Method
    public boolean matches(IItemStack var1, boolean var2);

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="empty")
    default public boolean isEmpty() {
        return this.asVanillaIngredient().m_43947_();
    }

    @ZenCodeType.Method
    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.CONTAINS)
    default public boolean contains(IIngredient ingredient) {
        return Arrays.stream(ingredient.getItems()).allMatch(this::matches);
    }

    @ZenCodeType.Method
    @ZenCodeType.Caster(implicit=true)
    public Ingredient asVanillaIngredient();

    @ZenCodeType.Method
    default public IItemStack getRemainingItem(IItemStack stack) {
        Item remainingItem = stack.getInternal().m_41720_().m_41469_();
        if (remainingItem != null) {
            return IItemStack.of(remainingItem.m_7968_());
        }
        return IItemStack.empty();
    }

    @Override
    @ZenCodeType.Getter(value="commandString")
    public String getCommandString();

    @ZenCodeType.Getter(value="items")
    public IItemStack[] getItems();

    @ZenCodeType.Method
    @ZenCodeType.Setter(value="burnTime")
    default public void setBurnTime(int time) {
        CraftTweakerAPI.apply(new ActionSetBurnTime(this, time));
    }

    @ZenCodeType.Method
    default public void clearTooltip(@ZenCodeType.OptionalBoolean boolean leaveName) {
        CraftTweakerAPI.apply(new ActionClearTooltip(this, leaveName));
    }

    @ZenCodeType.Method
    default public void addTooltip(Component content) {
        CraftTweakerAPI.apply(new ActionAddTooltip(this, content));
    }

    @ZenCodeType.Method
    default public void addShiftTooltip(Component content, @ZenCodeType.Optional Component showMessage) {
        CraftTweakerAPI.apply(new ActionAddShiftedTooltip(this, content, showMessage));
    }

    @ZenCodeType.Method
    default public void modifyTooltip(ITooltipFunction function) {
        CraftTweakerAPI.apply(new ActionModifyTooltip(this, function));
    }

    @ZenCodeType.Method
    default public void modifyShiftTooltip(ITooltipFunction shiftedFunction, @ZenCodeType.Optional ITooltipFunction unshiftedFunction) {
        CraftTweakerAPI.apply(new ActionModifyShiftedTooltip(this, shiftedFunction, unshiftedFunction));
    }

    @ZenCodeType.Method
    default public void removeTooltip(String regex) {
        CraftTweakerAPI.apply(new ActionRemoveRegexTooltip(this, Pattern.compile(regex)));
    }

    @ZenCodeType.Method
    default public void addGlobalAttributeModifier(Attribute attribute, String name, double value, AttributeModifier.Operation operation, EquipmentSlot[] slotTypes) {
        AttributeModifier modifier = new AttributeModifier(name, value, operation);
        this.addModifier(attribute, slotTypes, modifier);
    }

    @ZenCodeType.Method
    default public void addGlobalAttributeModifier(Attribute attribute, String uuid, String name, double value, AttributeModifier.Operation operation, EquipmentSlot[] slotTypes) {
        this.addGlobalAttributeModifier(attribute, UUID.fromString(uuid), name, value, operation, slotTypes);
    }

    @ZenCodeType.Method
    default public void addGlobalAttributeModifier(Attribute attribute, UUID uuid, String name, double value, AttributeModifier.Operation operation, EquipmentSlot[] slotTypes) {
        AttributeModifier modifier = new AttributeModifier(uuid, name, value, operation);
        this.addModifier(attribute, slotTypes, modifier);
    }

    private void addModifier(Attribute attribute, EquipmentSlot[] slotTypes, AttributeModifier modifier) {
        HashSet<EquipmentSlot> validSlots = new HashSet<EquipmentSlot>(Arrays.asList(slotTypes));
        CraftTweakerAPI.apply(new ActionModifyAttribute(this, event -> {
            if (validSlots.contains(event.getSlotType())) {
                if (event.getModifiers().containsEntry((Object)attribute, (Object)modifier)) {
                    event.removeModifier(attribute, modifier);
                }
                event.addModifier(attribute, modifier);
            }
        }));
    }

    @ZenCodeType.Method
    default public void removeGlobalAttribute(Attribute attribute, EquipmentSlot[] slotTypes) {
        HashSet<EquipmentSlot> validSlots = new HashSet<EquipmentSlot>(Arrays.asList(slotTypes));
        CraftTweakerAPI.apply(new ActionModifyAttribute(this, event -> {
            if (validSlots.contains(event.getSlotType())) {
                event.removeAttribute(attribute);
            }
        }));
    }

    @ZenCodeType.Method
    default public void removeGlobalAttributeModifier(String uuid, EquipmentSlot[] slotTypes) {
        this.removeGlobalAttributeModifier(UUID.fromString(uuid), slotTypes);
    }

    @ZenCodeType.Method
    default public void removeGlobalAttributeModifier(UUID uuid, EquipmentSlot[] slotTypes) {
        HashSet<EquipmentSlot> validSlots = new HashSet<EquipmentSlot>(Arrays.asList(slotTypes));
        CraftTweakerAPI.apply(new ActionModifyAttribute(this, event -> {
            if (validSlots.contains(event.getSlotType())) {
                event.getModifiers().entries().stream().filter(entry -> ((AttributeModifier)entry.getValue()).m_22209_().equals(uuid)).forEach(entry -> event.removeModifier((Attribute)entry.getKey(), (AttributeModifier)entry.getValue()));
            }
        }));
    }

    public static IIngredient fromIngredient(Ingredient ingredient) {
        return IngredientConverter.fromIngredient(ingredient);
    }

    @ZenCodeType.Caster(implicit=true)
    default public MapData asMapData() {
        IData data = this.asIData();
        return data instanceof MapData ? (MapData)data : new MapData();
    }

    @ZenCodeType.Caster(implicit=true)
    default public IData asIData() {
        return JSONConverter.convert(this.asVanillaIngredient().m_43942_());
    }

    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.OR)
    default public IIngredientList or(IIngredient other) {
        return new IIngredientList(new IIngredient[]{this, other});
    }

    @ZenCodeType.Method
    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.MUL)
    default public IIngredientWithAmount mul(int amount) {
        return new IngredientWithAmount(this, amount);
    }

    @ZenCodeType.Method
    @ZenCodeType.Caster(implicit=true)
    default public IIngredientWithAmount asIIngredientWithAmount() {
        if (this instanceof IIngredientWithAmount) {
            return (IIngredientWithAmount)((Object)this);
        }
        return this.mul(1);
    }

    @ZenCodeType.Method
    default public IIngredientTransformed<IIngredient> transformReplace(IItemStack replaceWith) {
        return new IIngredientTransformed<IIngredient>(this, new TransformReplace(replaceWith));
    }

    @ZenCodeType.Method
    default public IIngredientTransformed<IIngredient> transformDamage(@ZenCodeType.OptionalInt(value=1) int amount) {
        return new IIngredientTransformed<IIngredient>(this, new TransformDamage(amount));
    }

    @ZenCodeType.Method
    default public IIngredientTransformed<IIngredient> transformCustom(String uid, @ZenCodeType.Optional Function<IItemStack, IItemStack> function) {
        return new IIngredientTransformed<IIngredient>(this, new TransformCustom(uid, function));
    }

    @ZenCodeType.Method
    default public IIngredientTransformed<IIngredient> reuse() {
        return new IIngredientTransformed<IIngredient>(this, new TransformReuse());
    }

    @ZenCodeType.Method
    default public IIngredientTransformed<IIngredient> transform(IIngredientTransformer<IIngredient> transformer) {
        return new IIngredientTransformed<IIngredient>(this, transformer);
    }

    @ZenCodeType.Method
    default public IIngredientConditioned<IIngredient> onlyDamaged() {
        return new IIngredientConditioned<IIngredient>(this, new ConditionDamaged());
    }

    @ZenCodeType.Method
    default public IIngredientConditioned<IIngredient> onlyDamagedAtLeast(int minDamage) {
        return new IIngredientConditioned<IIngredient>(this, new ConditionDamagedAtLeast(minDamage));
    }

    @ZenCodeType.Method
    default public IIngredientConditioned<IIngredient> onlyDamagedAtMost(int maxDamage) {
        return new IIngredientConditioned<IIngredient>(this, new ConditionDamagedAtMost(maxDamage));
    }

    @ZenCodeType.Method
    default public IIngredientConditioned<IIngredient> anyDamage() {
        return new IIngredientConditioned<IIngredient>(this, new ConditionAnyDamage());
    }

    @ZenCodeType.Method
    default public IIngredientConditioned<IIngredient> onlyIf(String uid, @ZenCodeType.Optional Predicate<IItemStack> function) {
        return new IIngredientConditioned<IIngredient>(this, new ConditionCustom(uid, function));
    }

    @ZenCodeType.Method
    default public IIngredientConditioned<IIngredient> only(IIngredientCondition<IIngredient> condition) {
        return new IIngredientConditioned<IIngredient>(this, condition);
    }
}

