/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.action.item.tooltip;

import com.blamejared.crafttweaker.api.action.item.tooltip.ActionTooltipBase;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.tooltip.ITooltipFunction;
import java.util.ArrayList;
import java.util.regex.Pattern;
import net.minecraft.network.chat.Component;

public class ActionRemoveRegexTooltip
extends ActionTooltipBase {
    private final Pattern regex;
    private final ITooltipFunction function;

    public ActionRemoveRegexTooltip(IIngredient stack, Pattern regex) {
        super(stack);
        this.regex = regex;
        this.function = (stack1, tooltip, context) -> {
            ArrayList<Component> content = new ArrayList<Component>();
            for (Component component : tooltip) {
                if (regex.matcher(component.getString()).find()) continue;
                content.add(component);
            }
            tooltip.clear();
            tooltip.addAll(content);
        };
    }

    @Override
    public void apply() {
        this.getTooltip().add(this.function);
    }

    @Override
    public void undo() {
        this.getTooltip().remove(this.function);
        this.pruneTooltips();
    }

    @Override
    public String describe() {
        return "Removing from the tooltip for: " + this.stack.getCommandString() + " based on the regex: \"" + this.regex + "\"";
    }

    @Override
    public String describeUndo() {
        return "Undoing removal from the tooltip for: " + this.stack.getCommandString() + " based on the regex: \"" + this.regex + "\"";
    }
}

