/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.ingredient.condition.type;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.ingredient.condition.IIngredientCondition;
import com.blamejared.crafttweaker.api.ingredient.condition.serializer.ConditionDamagedAtMostSerializer;
import com.blamejared.crafttweaker.api.ingredient.condition.serializer.IIngredientConditionSerializer;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.ingredient.condition.type.ConditionDamagedAtMost")
@Document(value="vanilla/api/ingredient/condition/type/ConditionDamagedAtMost")
public class ConditionDamagedAtMost<T extends IIngredient>
implements IIngredientCondition<T> {
    private final int maxDamage;

    public ConditionDamagedAtMost(int maxDamage) {
        this.maxDamage = maxDamage;
    }

    @Override
    public boolean matches(IItemStack stack) {
        return stack.getDamage() <= this.maxDamage;
    }

    @Override
    public boolean ignoresDamage() {
        return true;
    }

    @Override
    public String getCommandString(IIngredient ingredient) {
        return String.format("%s.onlyDamagedAtMost(%s)", ingredient.getCommandString(), this.maxDamage);
    }

    @Override
    public IIngredientConditionSerializer getSerializer() {
        return ConditionDamagedAtMostSerializer.INSTANCE;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConditionDamagedAtMost that = (ConditionDamagedAtMost)o;
        return this.maxDamage == that.maxDamage;
    }

    public int hashCode() {
        return this.maxDamage;
    }

    public int getMaxDamage() {
        return this.maxDamage;
    }
}

