/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zenscript.parser.expression;

import java.util.ArrayList;
import org.openzen.zencode.shared.CodePosition;
import org.openzen.zencode.shared.CompileException;
import org.openzen.zenscript.codemodel.expression.Expression;
import org.openzen.zenscript.codemodel.expression.RangeExpression;
import org.openzen.zenscript.codemodel.partial.IPartialExpression;
import org.openzen.zenscript.codemodel.scope.ExpressionScope;
import org.openzen.zenscript.codemodel.type.RangeTypeID;
import org.openzen.zenscript.codemodel.type.TypeID;
import org.openzen.zenscript.parser.expression.ParsedExpression;

public class ParsedExpressionRange
extends ParsedExpression {
    private final ParsedExpression from;
    private final ParsedExpression to;

    public ParsedExpressionRange(CodePosition position, ParsedExpression from, ParsedExpression to) {
        super(position);
        this.from = from;
        this.to = to;
    }

    @Override
    public IPartialExpression compile(ExpressionScope scope) throws CompileException {
        ArrayList<TypeID> fromHints = new ArrayList<TypeID>();
        ArrayList<TypeID> toHints = new ArrayList<TypeID>();
        for (TypeID hint : scope.hints) {
            if (!(hint instanceof RangeTypeID)) continue;
            RangeTypeID rangeHint = (RangeTypeID)hint;
            if (!fromHints.contains(rangeHint.baseType)) {
                fromHints.add(rangeHint.baseType);
            }
            if (toHints.contains(rangeHint.baseType)) continue;
            toHints.add(rangeHint.baseType);
        }
        Expression from = this.from.compile(scope.withHints(fromHints)).eval();
        Expression to = this.to.compile(scope.withHints(toHints)).eval();
        TypeID baseType = scope.getTypeMembers(from.type).union(to.type);
        return new RangeExpression(this.position, scope.getTypeRegistry().getRange(baseType), from, to);
    }

    @Override
    public boolean hasStrongType() {
        return this.from.hasStrongType() && this.to.hasStrongType();
    }
}

