/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.villager;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.action.villager.ActionAddTrade;
import com.blamejared.crafttweaker.api.action.villager.ActionAddWanderingTrade;
import com.blamejared.crafttweaker.api.action.villager.ActionRemoveTrade;
import com.blamejared.crafttweaker.api.action.villager.ActionRemoveWanderingTrade;
import com.blamejared.crafttweaker.api.action.villager.ActionTradeBase;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.villager.CTTradeObject;
import com.blamejared.crafttweaker.api.villager.ITradeRemover;
import com.blamejared.crafttweaker.api.villager.trade.type.BasicTradeListing;
import com.blamejared.crafttweaker.api.villager.trade.type.CustomTradeListing;
import com.blamejared.crafttweaker.api.villager.trade.type.IBasicItemListing;
import com.blamejared.crafttweaker.mixin.common.access.villager.AccessDyedArmorForEmeralds;
import com.blamejared.crafttweaker.mixin.common.access.villager.AccessEmeraldForItems;
import com.blamejared.crafttweaker.mixin.common.access.villager.AccessEnchantedItemForEmeralds;
import com.blamejared.crafttweaker.mixin.common.access.villager.AccessItemsAndEmeraldsToItems;
import com.blamejared.crafttweaker.mixin.common.access.villager.AccessItemsForEmeralds;
import com.blamejared.crafttweaker.mixin.common.access.villager.AccessTippedArrowForItemsAndEmeralds;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.MerchantOffer;
import org.openzen.zencode.java.ZenCodeGlobals;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.villagers.VillagerTrades")
@Document(value="vanilla/api/villager/VillagerTrades")
public class CTVillagerTrades {
    @ZenCodeGlobals.Global(value="villagerTrades")
    public static final CTVillagerTrades INSTANCE = new CTVillagerTrades();
    public static final List<ActionTradeBase> ACTIONS_VILLAGER_TRADES = new ArrayList<ActionTradeBase>();
    public static final List<ActionTradeBase> ACTION_WANDERING_TRADES = new ArrayList<ActionTradeBase>();
    public static final Map<Class<VillagerTrades.ItemListing>, Function<VillagerTrades.ItemListing, CTTradeObject>> TRADE_CONVERTER = new HashMap<Class<VillagerTrades.ItemListing>, Function<VillagerTrades.ItemListing, CTTradeObject>>();
    public static boolean RAN_EVENTS = false;

    @ZenCodeType.Method
    public void addTrade(VillagerProfession profession, int villagerLevel, BiFunction<Entity, RandomSource, @ZenCodeType.Nullable MerchantOffer> offerGenerator) {
        CustomTradeListing trade = new CustomTradeListing(offerGenerator);
        this.addTradeInternal(profession, villagerLevel, trade);
    }

    @ZenCodeType.Method
    public void addTrade(VillagerProfession profession, int villagerLevel, int emeralds, ItemStack forSale, int maxTrades, int xp, @ZenCodeType.OptionalFloat(value=1.0f) float priceMult) {
        BasicTradeListing trade = new BasicTradeListing(emeralds, forSale, maxTrades, xp, priceMult);
        this.addTradeInternal(profession, villagerLevel, trade);
    }

    @ZenCodeType.Method
    public void addTrade(VillagerProfession profession, int villagerLevel, ItemStack input1, ItemStack forSale, int maxTrades, int xp, @ZenCodeType.OptionalFloat(value=1.0f) float priceMult) {
        BasicTradeListing trade = new BasicTradeListing(input1, forSale, maxTrades, xp, priceMult);
        this.addTradeInternal(profession, villagerLevel, trade);
    }

    @ZenCodeType.Method
    public void addTrade(VillagerProfession profession, int villagerLevel, ItemStack input1, ItemStack input2, ItemStack forSale, int maxTrades, int xp, @ZenCodeType.OptionalFloat(value=1.0f) float priceMult) {
        BasicTradeListing trade = new BasicTradeListing(input1, input2, forSale, maxTrades, xp, priceMult);
        this.addTradeInternal(profession, villagerLevel, trade);
    }

    @ZenCodeType.Method
    public void addTrade(VillagerProfession profession, int villagerLevel, VillagerTrades.ItemListing trade) {
        this.addTradeInternal(profession, villagerLevel, trade);
    }

    @ZenCodeType.Method
    public void removeBasicTrade(VillagerProfession profession, int villagerLevel, IItemStack forSale, @ZenCodeType.Optional(value="<item:minecraft:air>") IItemStack price, @ZenCodeType.Optional(value="<item:minecraft:air>") IItemStack price2) {
        this.removeTradeInternal(profession, villagerLevel, trade -> {
            if (trade instanceof IBasicItemListing) {
                IBasicItemListing basicTrade = (IBasicItemListing)trade;
                boolean saleMatches = forSale.matches(IItemStack.ofMutable(basicTrade.getForSale()));
                if (price.isEmpty() && price2.isEmpty()) {
                    return saleMatches;
                }
                boolean priceMatches = price.matches(IItemStack.ofMutable(basicTrade.getPrice()));
                if (!price.isEmpty() && price2.isEmpty()) {
                    return saleMatches && priceMatches;
                }
                boolean price2Matches = price2.matches(IItemStack.ofMutable(basicTrade.getPrice2()));
                return saleMatches && priceMatches && price2Matches;
            }
            return false;
        });
    }

    @ZenCodeType.Method
    public void removeEmeraldForItemsTrade(VillagerProfession profession, int villagerLevel, Item tradeFor) {
        this.removeTradeInternal(profession, villagerLevel, trade -> {
            if (trade instanceof VillagerTrades.EmeraldForItems) {
                return ((AccessEmeraldForItems)trade).crafttweaker$getItem() == tradeFor;
            }
            if (trade instanceof IBasicItemListing) {
                IBasicItemListing basicTrade = (IBasicItemListing)trade;
                return basicTrade.getForSale().m_41720_() == tradeFor;
            }
            return false;
        });
    }

    @ZenCodeType.Method
    public void removeItemsForEmeraldsTrade(VillagerProfession profession, int villagerLevel, IItemStack sellingItem) {
        this.removeTradeInternal(profession, villagerLevel, trade -> {
            if (trade instanceof VillagerTrades.ItemsForEmeralds) {
                return sellingItem.matches(IItemStack.ofMutable(((AccessItemsForEmeralds)trade).crafttweaker$getItemStack()));
            }
            if (trade instanceof IBasicItemListing) {
                IBasicItemListing basicTrade = (IBasicItemListing)trade;
                return IItemStack.ofMutable(basicTrade.getPrice()).matches(sellingItem);
            }
            return false;
        });
    }

    @ZenCodeType.Method
    public void removeItemsAndEmeraldsToItemsTrade(VillagerProfession profession, int villagerLevel, IItemStack sellingItem, IItemStack buyingItem) {
        this.removeTradeInternal(profession, villagerLevel, trade -> {
            IBasicItemListing basicTrade;
            if (trade instanceof VillagerTrades.ItemsAndEmeraldsToItems) {
                if (sellingItem.matches(IItemStack.ofMutable(((AccessItemsAndEmeraldsToItems)trade).crafttweaker$getToItem()))) {
                    return buyingItem.matches(IItemStack.ofMutable(((AccessItemsAndEmeraldsToItems)trade).crafttweaker$getFromItem()));
                }
            } else if (trade instanceof IBasicItemListing && sellingItem.matches(IItemStack.ofMutable((basicTrade = (IBasicItemListing)trade).getPrice()))) {
                return buyingItem.matches(IItemStack.ofMutable(basicTrade.getForSale()));
            }
            return false;
        });
    }

    @ZenCodeType.Method
    public void removeTippedArrowForItemsAndEmeraldsTrade(VillagerProfession profession, int villagerLevel, IItemStack potionStack, Item sellingItem) {
        this.removeTradeInternal(profession, villagerLevel, trade -> {
            if (trade instanceof VillagerTrades.TippedArrowForItemsAndEmeralds && potionStack.matches(IItemStack.ofMutable(((AccessTippedArrowForItemsAndEmeralds)trade).crafttweaker$getToItem()))) {
                return sellingItem == ((AccessTippedArrowForItemsAndEmeralds)trade).crafttweaker$getFromItem();
            }
            return false;
        });
    }

    @ZenCodeType.Method
    public void removeDyedArmorForEmeraldsTrade(VillagerProfession profession, int villagerLevel, Item buyingItem) {
        this.removeTradeInternal(profession, villagerLevel, trade -> {
            if (trade instanceof VillagerTrades.DyedArmorForEmeralds) {
                return ((AccessDyedArmorForEmeralds)trade).crafttweaker$getItem() == buyingItem;
            }
            return false;
        });
    }

    @ZenCodeType.Method
    public void removeTreasureMapForEmeraldsTrade(VillagerProfession profession, int villagerLevel) {
        this.removeTradeInternal(profession, villagerLevel, trade -> trade instanceof VillagerTrades.TreasureMapForEmeralds);
    }

    @ZenCodeType.Method
    public void removeEnchantBookForEmeraldsTrade(VillagerProfession profession, int villagerLevel) {
        this.removeTradeInternal(profession, villagerLevel, trade -> trade instanceof VillagerTrades.EnchantBookForEmeralds);
    }

    @ZenCodeType.Method
    public void removeEnchantedItemForEmeraldsTrade(VillagerProfession profession, int villagerLevel, IItemStack buyingItem) {
        this.removeTradeInternal(profession, villagerLevel, trade -> {
            if (trade instanceof VillagerTrades.EnchantedItemForEmeralds) {
                return buyingItem.matches(IItemStack.ofMutable(((AccessEnchantedItemForEmeralds)trade).crafttweaker$getItemStack()));
            }
            return false;
        });
    }

    @ZenCodeType.Method
    public void removeSuspiciousStewForEmeraldTrade(VillagerProfession profession, int villagerLevel) {
        this.removeTradeInternal(profession, villagerLevel, trade -> trade instanceof VillagerTrades.SuspiciousStewForEmerald);
    }

    @ZenCodeType.Method
    public void removeAllTrades(VillagerProfession profession, int villagerLevel) {
        this.removeTradeInternal(profession, villagerLevel, trade -> true);
    }

    @ZenCodeType.Method
    public void removeTrade(VillagerProfession profession, int villagerLevel, IIngredient buying, IIngredient selling, @ZenCodeType.Optional(value="<item:minecraft:air>") IIngredient secondBuying) {
        this.removeTradeInternal(profession, villagerLevel, trade -> {
            Function<VillagerTrades.ItemListing, CTTradeObject> tradeFunc = TRADE_CONVERTER.get(trade.getClass());
            if (tradeFunc == null) {
                return false;
            }
            CTTradeObject tradeObject = tradeFunc.apply(trade);
            if (!buying.matches(tradeObject.getBuyingStack())) {
                return false;
            }
            if (!selling.matches(tradeObject.getSellingStack())) {
                return false;
            }
            return secondBuying.matches(tradeObject.getBuyingStackSecond());
        });
    }

    @ZenCodeType.Method
    public void removeTradesSelling(VillagerProfession profession, int villagerLevel, IIngredient selling) {
        this.removeTradeInternal(profession, villagerLevel, trade -> {
            Function<VillagerTrades.ItemListing, CTTradeObject> tradeFunc = TRADE_CONVERTER.get(trade.getClass());
            if (tradeFunc == null) {
                return false;
            }
            CTTradeObject tradeObject = tradeFunc.apply(trade);
            return selling.matches(tradeObject.getSellingStack());
        });
    }

    @ZenCodeType.Method
    public void removeTradesBuying(VillagerProfession profession, int villagerLevel, IIngredient buying) {
        this.removeTradeInternal(profession, villagerLevel, trade -> {
            Function<VillagerTrades.ItemListing, CTTradeObject> tradeFunc = TRADE_CONVERTER.get(trade.getClass());
            if (tradeFunc == null) {
                return false;
            }
            CTTradeObject tradeObject = tradeFunc.apply(trade);
            return buying.matches(tradeObject.getBuyingStack());
        });
    }

    @ZenCodeType.Method
    public void removeTradesBuying(VillagerProfession profession, int villagerLevel, IIngredient buying, IIngredient secondBuying) {
        this.removeTradeInternal(profession, villagerLevel, trade -> {
            Function<VillagerTrades.ItemListing, CTTradeObject> tradeFunc = TRADE_CONVERTER.get(trade.getClass());
            if (tradeFunc == null) {
                return false;
            }
            CTTradeObject tradeObject = tradeFunc.apply(trade);
            if (!buying.matches(tradeObject.getBuyingStack())) {
                return false;
            }
            return secondBuying.matches(tradeObject.getBuyingStackSecond());
        });
    }

    @ZenCodeType.Method
    public void addWanderingTrade(int rarity, VillagerTrades.ItemListing trade) {
        this.addWanderingTradeInternal(rarity, trade);
    }

    @ZenCodeType.Method
    public void addWanderingTrade(int rarity, int emeralds, ItemStack forSale, int maxTrades, int xp) {
        BasicTradeListing trade = new BasicTradeListing(emeralds, forSale, maxTrades, xp, 1.0f);
        this.addWanderingTradeInternal(rarity, trade);
    }

    @ZenCodeType.Method
    public void addWanderingTrade(int rarity, IItemStack price, IItemStack forSale, int maxTrades, int xp) {
        BasicTradeListing trade = new BasicTradeListing(price.getInternal(), forSale.getInternal(), maxTrades, xp, 1.0f);
        this.addWanderingTradeInternal(rarity, trade);
    }

    @Deprecated(forRemoval=true)
    public void removeWanderingTrade(int rarity, IItemStack tradeFor) {
        this.removeWanderingTrade(rarity, (IIngredient)tradeFor);
    }

    @ZenCodeType.Method
    public void removeWanderingTrade(int rarity, IIngredient tradeFor) {
        this.removeWanderingTradeInternal(rarity, trade -> {
            Function<VillagerTrades.ItemListing, CTTradeObject> tradeFunc = TRADE_CONVERTER.get(trade.getClass());
            if (tradeFunc == null) {
                return false;
            }
            CTTradeObject tradeObject = tradeFunc.apply(trade);
            return tradeFor.matches(tradeObject.getSellingStack());
        });
    }

    @ZenCodeType.Method
    public void removeAllWanderingTrades(int rarity) {
        this.removeWanderingTradeInternal(rarity, trade -> true);
    }

    private void addTradeInternal(VillagerProfession profession, int villagerLevel, VillagerTrades.ItemListing trade) {
        this.apply(new ActionAddTrade(profession, villagerLevel, trade), false);
    }

    private void addWanderingTradeInternal(int villagerLevel, VillagerTrades.ItemListing trade) {
        this.apply(new ActionAddWanderingTrade(villagerLevel, trade), true);
    }

    private void removeTradeInternal(VillagerProfession profession, int villagerLevel, ITradeRemover remover) {
        this.apply(new ActionRemoveTrade(profession, villagerLevel, remover), false);
    }

    private void removeWanderingTradeInternal(int villagerLevel, ITradeRemover remover) {
        this.apply(new ActionRemoveWanderingTrade(villagerLevel, remover), true);
    }

    private void apply(ActionTradeBase action, boolean wandering) {
        if (!RAN_EVENTS) {
            if (wandering) {
                ACTION_WANDERING_TRADES.add(action);
            } else {
                ACTIONS_VILLAGER_TRADES.add(action);
            }
        }
        CraftTweakerAPI.apply(action);
    }
}

