/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.data.converter;

import com.blamejared.crafttweaker.api.data.ByteData;
import com.blamejared.crafttweaker.api.data.DoubleData;
import com.blamejared.crafttweaker.api.data.FloatData;
import com.blamejared.crafttweaker.api.data.IData;
import com.blamejared.crafttweaker.api.data.IntData;
import com.blamejared.crafttweaker.api.data.ListData;
import com.blamejared.crafttweaker.api.data.LongData;
import com.blamejared.crafttweaker.api.data.MapData;
import com.blamejared.crafttweaker.api.data.ShortData;
import com.blamejared.crafttweaker.api.data.StringData;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class JSONConverter {
    public static IData convert(JsonElement json) {
        if (json == null) {
            return null;
        }
        if (json.isJsonPrimitive()) {
            JsonPrimitive primitive = json.getAsJsonPrimitive();
            if (primitive.isString() || primitive.isBoolean()) {
                return new StringData(primitive.getAsString());
            }
            Number number = primitive.getAsNumber();
            if (number == null) {
                return null;
            }
            if (number instanceof Integer) {
                return new IntData(number.intValue());
            }
            if (number instanceof Byte) {
                return new ByteData(number.byteValue());
            }
            if (number instanceof Double) {
                return new DoubleData(number.doubleValue());
            }
            if (number instanceof Float) {
                return new FloatData(number.floatValue());
            }
            if (number instanceof Long) {
                return new LongData(number.longValue());
            }
            if (number instanceof Short) {
                return new ShortData(number.shortValue());
            }
            return new DoubleData(number.doubleValue());
        }
        if (json.isJsonArray()) {
            JsonArray asJsonArray = json.getAsJsonArray();
            ArrayList<IData> dataList = new ArrayList<IData>(asJsonArray.size());
            for (JsonElement jsonElement : asJsonArray) {
                dataList.add(JSONConverter.convert(jsonElement));
            }
            return new ListData(dataList);
        }
        if (json.isJsonObject()) {
            return JSONConverter.convert(json.getAsJsonObject());
        }
        return null;
    }

    public static MapData convert(JsonObject jsonObject) {
        if (jsonObject == null) {
            return null;
        }
        HashMap<String, IData> dataMap = new HashMap<String, IData>();
        for (Map.Entry e : jsonObject.entrySet()) {
            dataMap.put((String)e.getKey(), JSONConverter.convert((JsonElement)e.getValue()));
        }
        return new MapData(dataMap);
    }
}

