/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.action.base;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.CraftTweakerConstants;
import com.blamejared.crafttweaker.api.zencode.IScriptLoadSource;
import com.blamejared.crafttweaker.api.zencode.IScriptLoader;
import com.blamejared.crafttweaker.api.zencode.util.PositionUtil;
import javax.annotation.Nonnull;
import org.apache.logging.log4j.Logger;
import org.openzen.zencode.shared.CodePosition;

public interface IAction {
    public void apply();

    public String describe();

    public String systemName();

    default public boolean validate(Logger logger) {
        return true;
    }

    default public boolean shouldApplyOn(IScriptLoadSource source, Logger logger) {
        return source.id().equals((Object)CraftTweakerConstants.RELOAD_LISTENER_SOURCE_ID);
    }

    @Nonnull
    default public CodePosition getDeclaredScriptPosition() {
        return PositionUtil.getZCScriptPositionFromStackTrace();
    }

    default public boolean assertLoader(IScriptLoader loader, Logger logger) {
        IScriptLoader currentLoader = CraftTweakerAPI.getScriptRunManager().currentRunInfo().loader();
        if (currentLoader.equals(loader)) {
            return true;
        }
        logger.warn("Action '{}' ({}) can only be invoked on loader '{}'. You tried to run it on loader '{}'.", (Object)this.getClass().getName(), (Object)this.getDeclaredScriptPosition(), (Object)loader, (Object)currentLoader);
        return false;
    }

    default public Logger logger() {
        return CraftTweakerAPI.getLogger(this.systemName());
    }
}

