/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zenscript.codemodel.partial;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openzen.zencode.shared.CodePosition;
import org.openzen.zencode.shared.CompileException;
import org.openzen.zenscript.codemodel.FunctionHeader;
import org.openzen.zenscript.codemodel.GenericName;
import org.openzen.zenscript.codemodel.expression.CallArguments;
import org.openzen.zenscript.codemodel.expression.Expression;
import org.openzen.zenscript.codemodel.expression.LambdaClosure;
import org.openzen.zenscript.codemodel.member.ref.FunctionalMemberRef;
import org.openzen.zenscript.codemodel.partial.IPartialExpression;
import org.openzen.zenscript.codemodel.scope.TypeScope;
import org.openzen.zenscript.codemodel.type.TypeID;
import org.openzen.zenscript.codemodel.type.member.TypeMember;
import org.openzen.zenscript.codemodel.type.member.TypeMemberGroup;

public class PartialMemberGroupExpression
implements IPartialExpression {
    private final CodePosition position;
    private final Expression target;
    private final TypeMemberGroup group;
    private final TypeID[] typeArguments;
    private final boolean allowStaticUsage;
    private final TypeScope scope;

    public PartialMemberGroupExpression(CodePosition position, TypeScope scope, Expression target, TypeMemberGroup group, TypeID[] typeArguments, boolean allowStaticMembers) {
        this.position = position;
        this.scope = scope;
        this.target = target;
        this.group = group;
        this.typeArguments = typeArguments;
        this.allowStaticUsage = allowStaticMembers;
    }

    public PartialMemberGroupExpression(CodePosition position, TypeScope scope, Expression target, String name, FunctionalMemberRef member, TypeID[] typeArguments, boolean allowStaticMembers) {
        this.position = position;
        this.scope = scope;
        this.target = target;
        this.group = TypeMemberGroup.forMethod(name, member);
        this.typeArguments = typeArguments;
        this.allowStaticUsage = allowStaticMembers;
    }

    @Override
    public Expression eval() throws CompileException {
        return this.group.getter(this.position, this.scope, this.target, this.allowStaticUsage);
    }

    @Override
    public List<TypeID> getAssignHints() {
        if (this.group.getSetter() != null) {
            return Collections.singletonList(this.group.getSetter().getType());
        }
        if (this.group.getField() != null) {
            return Collections.singletonList(this.group.getField().getType());
        }
        return Collections.emptyList();
    }

    @Override
    public List<TypeID>[] predictCallTypes(CodePosition position, TypeScope scope, List<TypeID> hints, int arguments) {
        return this.group.predictCallTypes(position, scope, hints, arguments);
    }

    @Override
    public List<FunctionHeader> getPossibleFunctionHeaders(TypeScope scope, List<TypeID> hints, int arguments) {
        ArrayList<FunctionHeader> results = new ArrayList<FunctionHeader>();
        for (TypeMember<FunctionalMemberRef> method : this.group.getMethodMembers()) {
            if (!((FunctionalMemberRef)method.member).accepts(arguments) || ((FunctionalMemberRef)method.member).isStatic()) continue;
            try {
                scope.getPreparer().prepare(((FunctionalMemberRef)method.member).getTarget());
                results.add(((FunctionalMemberRef)method.member).getHeader());
            }
            catch (CompileException compileException) {}
        }
        return results;
    }

    @Override
    public IPartialExpression getMember(CodePosition position, TypeScope scope, List<TypeID> hints, GenericName name) throws CompileException {
        return this.eval().getMember(position, scope, hints, name);
    }

    @Override
    public Expression call(CodePosition position, TypeScope scope, List<TypeID> hints, CallArguments arguments) throws CompileException {
        return this.group.call(position, scope, this.target, arguments, this.allowStaticUsage);
    }

    @Override
    public Expression assign(CodePosition position, TypeScope scope, Expression value) throws CompileException {
        return this.group.setter(position, scope, this.target, value, this.allowStaticUsage);
    }

    @Override
    public IPartialExpression capture(CodePosition position, LambdaClosure closure) throws CompileException {
        return new PartialMemberGroupExpression(position, this.scope, this.target.capture(position, closure).eval(), this.group, this.typeArguments, this.allowStaticUsage);
    }

    @Override
    public TypeID[] getTypeArguments() {
        return this.typeArguments;
    }
}

