/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.platform.services;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.CraftTweakerConstants;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.ingredient.condition.serializer.IIngredientConditionSerializer;
import com.blamejared.crafttweaker.api.ingredient.transform.serializer.IIngredientTransformerSerializer;
import com.blamejared.crafttweaker.api.ingredient.type.IIngredientConditioned;
import com.blamejared.crafttweaker.api.ingredient.type.IIngredientTransformed;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.recipe.MirrorAxis;
import com.blamejared.crafttweaker.api.recipe.function.RecipeFunctionArray;
import com.blamejared.crafttweaker.api.recipe.function.RecipeFunctionMatrix;
import com.blamejared.crafttweaker.api.recipe.serializer.ICTShapedRecipeBaseSerializer;
import com.blamejared.crafttweaker.api.recipe.serializer.ICTShapelessRecipeBaseSerializer;
import com.blamejared.crafttweaker.api.recipe.type.CTShapedRecipeBase;
import com.blamejared.crafttweaker.api.recipe.type.CTShapelessRecipeBase;
import com.blamejared.crafttweaker.api.util.GenericUtil;
import com.blamejared.crafttweaker.platform.registry.RegistryWrapper;
import com.blamejared.crafttweaker.platform.registry.VanillaRegistryWrapper;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Lifecycle;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.WritableRegistry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;

public interface IRegistryHelper {
    default public Set<ResourceKey<?>> serverOnlyRegistries() {
        return StreamSupport.stream(RegistryAccess.knownRegistries().spliterator(), false).filter(registryData -> !registryData.sendToClient()).map(RegistryAccess.RegistryData::key).collect(Collectors.toSet());
    }

    default public void registerSerializer(MappedRegistry<IIngredientTransformerSerializer<?>> registry, IIngredientTransformerSerializer<?> serializer) {
        registry.register(ResourceKey.create((ResourceKey)registry.key(), (ResourceLocation)serializer.getType()), serializer, Lifecycle.stable());
    }

    default public void registerSerializer(MappedRegistry<IIngredientConditionSerializer<?>> registry, IIngredientConditionSerializer<?> serializer) {
        registry.register(ResourceKey.create((ResourceKey)registry.key(), (ResourceLocation)serializer.getType()), serializer, Lifecycle.stable());
    }

    default public <T> MappedRegistry<T> registerVanillaRegistry(ResourceLocation location) {
        WritableRegistry registry = (WritableRegistry)Registry.REGISTRY;
        ResourceKey regKey = ResourceKey.createRegistryKey((ResourceLocation)location);
        Lifecycle stable = Lifecycle.stable();
        MappedRegistry mappedReg = new MappedRegistry(regKey, stable, null);
        registry.register(regKey, (Object)mappedReg, stable);
        return mappedReg;
    }

    public void init();

    public ICTShapedRecipeBaseSerializer getCTShapedRecipeSerializer();

    public ICTShapelessRecipeBaseSerializer getCTShapelessRecipeSerializer();

    default public CTShapedRecipeBase createCTShapedRecipe(String name, IItemStack output, IIngredient[][] ingredients, MirrorAxis mirrorAxis, @Nullable RecipeFunctionMatrix function) {
        return this.getCTShapedRecipeSerializer().makeRecipe(CraftTweakerConstants.rl(name), output, ingredients, mirrorAxis, function);
    }

    default public CTShapelessRecipeBase createCTShapelessRecipe(String name, IItemStack output, IIngredient[] ingredients, @Nullable RecipeFunctionArray function) {
        return this.getCTShapelessRecipeSerializer().makeRecipe(CraftTweakerConstants.rl(name), output, ingredients, function);
    }

    public Ingredient getIngredientAny();

    public Ingredient getIngredientList(List<Ingredient> var1);

    public <T extends IIngredient> Ingredient getIngredientConditioned(IIngredientConditioned<T> var1);

    public <T extends IIngredient> Ingredient getIngredientTransformed(IIngredientTransformed<T> var1);

    public Ingredient getIngredientPartialTag(ItemStack var1);

    default public Optional<ResourceLocation> maybeGetRegistryKey(Object object) {
        if (object instanceof Item) {
            Item obj = (Item)object;
            return Optional.of(this.getRegistryKey(obj));
        }
        if (object instanceof Potion) {
            Potion obj = (Potion)object;
            return Optional.of(this.getRegistryKey(obj));
        }
        if (object instanceof EntityType) {
            EntityType obj = (EntityType)object;
            return Optional.of(this.getRegistryKey(obj));
        }
        if (object instanceof RecipeType) {
            RecipeType obj = (RecipeType)object;
            return Optional.of(this.getRegistryKey(obj));
        }
        if (object instanceof RecipeSerializer) {
            RecipeSerializer obj = (RecipeSerializer)object;
            return Optional.of(this.getRegistryKey(obj));
        }
        if (object instanceof Attribute) {
            Attribute obj = (Attribute)object;
            return Optional.of(this.getRegistryKey(obj));
        }
        if (object instanceof Fluid) {
            Fluid obj = (Fluid)object;
            return Optional.of(this.getRegistryKey(obj));
        }
        if (object instanceof Enchantment) {
            Enchantment obj = (Enchantment)object;
            return Optional.of(this.getRegistryKey(obj));
        }
        if (object instanceof Block) {
            Block obj = (Block)object;
            return Optional.of(this.getRegistryKey(obj));
        }
        if (object instanceof MobEffect) {
            MobEffect obj = (MobEffect)object;
            return Optional.of(this.getRegistryKey(obj));
        }
        if (object instanceof VillagerProfession) {
            VillagerProfession obj = (VillagerProfession)object;
            return Optional.of(this.getRegistryKey(obj));
        }
        if (object instanceof Biome) {
            Biome obj = (Biome)object;
            return Optional.of(this.getRegistryKey(obj));
        }
        if (object instanceof SoundEvent) {
            SoundEvent obj = (SoundEvent)object;
            return Optional.of(this.getRegistryKey(obj));
        }
        return Optional.empty();
    }

    default public ResourceLocation getRegistryKey(Item item) {
        return this.items().getKey(item);
    }

    default public ResourceLocation getRegistryKey(Potion potion) {
        return this.potions().getKey(potion);
    }

    default public ResourceLocation getRegistryKey(EntityType<?> type) {
        return this.entityTypes().getKey(type);
    }

    default public ResourceLocation getRegistryKey(RecipeType<?> type) {
        return this.recipeTypes().getKey(type);
    }

    default public ResourceLocation getRegistryKey(RecipeSerializer<?> serializer) {
        return this.recipeSerializers().getKey(serializer);
    }

    default public ResourceLocation getRegistryKey(Attribute attribute) {
        return this.attributes().getKey(attribute);
    }

    default public ResourceLocation getRegistryKey(Fluid fluid) {
        return this.fluids().getKey(fluid);
    }

    default public ResourceLocation getRegistryKey(Enchantment enchantment) {
        return this.enchantments().getKey(enchantment);
    }

    default public ResourceLocation getRegistryKey(Block block) {
        return this.blocks().getKey(block);
    }

    default public ResourceLocation getRegistryKey(MobEffect mobEffect) {
        return this.mobEffects().getKey(mobEffect);
    }

    default public ResourceLocation getRegistryKey(VillagerProfession profession) {
        return this.villagerProfessions().getKey(profession);
    }

    default public ResourceLocation getRegistryKey(Biome biome) {
        return this.biomes().getKey(biome);
    }

    default public ResourceLocation getRegistryKey(SoundEvent biome) {
        return this.soundEvents().getKey(biome);
    }

    private <T> RegistryWrapper<T> wrap(Registry<T> registry) {
        return new VanillaRegistryWrapper<T>(registry);
    }

    default public RegistryWrapper<Item> items() {
        return this.wrap((Registry)Registry.ITEM);
    }

    default public RegistryWrapper<Potion> potions() {
        return this.wrap((Registry)Registry.POTION);
    }

    default public RegistryWrapper<RecipeType<?>> recipeTypes() {
        return this.wrap(Registry.RECIPE_TYPE);
    }

    default public RegistryWrapper<RecipeSerializer<?>> recipeSerializers() {
        return this.wrap(Registry.RECIPE_SERIALIZER);
    }

    default public RegistryWrapper<Attribute> attributes() {
        return this.wrap(Registry.ATTRIBUTE);
    }

    default public RegistryWrapper<Fluid> fluids() {
        return this.wrap((Registry)Registry.FLUID);
    }

    default public RegistryWrapper<Enchantment> enchantments() {
        return this.wrap(Registry.ENCHANTMENT);
    }

    default public RegistryWrapper<Block> blocks() {
        return this.wrap((Registry)Registry.BLOCK);
    }

    default public RegistryWrapper<MobEffect> mobEffects() {
        return this.wrap(Registry.MOB_EFFECT);
    }

    default public RegistryWrapper<VillagerProfession> villagerProfessions() {
        return this.wrap((Registry)Registry.VILLAGER_PROFESSION);
    }

    default public RegistryWrapper<SoundEvent> soundEvents() {
        return this.wrap(Registry.SOUND_EVENT);
    }

    default public RegistryWrapper<Biome> biomes() {
        return this.wrap(CraftTweakerAPI.getAccessibleElementsProvider().registryAccess().registryOrThrow(Registry.BIOME_REGISTRY));
    }

    default public RegistryWrapper<EntityType<?>> entityTypes() {
        return this.wrap((Registry)Registry.ENTITY_TYPE);
    }

    default public <T> Holder<T> makeHolder(ResourceKey<?> resourceKey, Either<T, ResourceLocation> objectOrKey) {
        return (Holder)objectOrKey.map(t -> this.makeHolder(resourceKey, t), key -> this.makeHolder(resourceKey, (ResourceLocation)key));
    }

    default public <T> Holder<T> makeHolder(ResourceKey<?> resourceKey, T object) {
        Registry registry = CraftTweakerAPI.getAccessibleElementsProvider().registryAccess().registryOrThrow((ResourceKey)GenericUtil.uncheck(resourceKey));
        return (Holder)registry.getResourceKey(object).flatMap(arg_0 -> ((Registry)registry).getHolder(arg_0)).orElseThrow(() -> new RuntimeException("Unable to make holder for registry: " + registry + " and object: " + object));
    }

    default public <T> Holder<T> makeHolder(ResourceKey<?> resourceKey, ResourceLocation key) {
        Registry registry = CraftTweakerAPI.getAccessibleElementsProvider().registryAccess().registryOrThrow((ResourceKey)GenericUtil.uncheck(resourceKey));
        if (!registry.containsKey(key)) {
            throw new IllegalArgumentException("Registry does not contain key: '" + key + "'");
        }
        return (Holder)registry.getHolder(ResourceKey.create((ResourceKey)registry.key(), (ResourceLocation)key)).orElseThrow(() -> new RuntimeException("Unable to make holder for registry: " + registry + " and id: " + key));
    }
}

