/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.platform.services;

import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.loot.modifier.ILootModifier;
import com.blamejared.crafttweaker.api.mod.Mod;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker.api.villager.CTTradeObject;
import com.blamejared.crafttweaker.impl.script.ScriptRecipe;
import com.blamejared.crafttweaker.mixin.common.access.item.AccessIngredient;
import com.blamejared.crafttweaker.platform.helper.inventory.IInventoryWrapper;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.material.Fluid;

public interface IPlatformHelper {
    default public String getLogFormat() {
        return "[%d{HH:mm:ss.SSS}][%level]: %msg%n%throwable";
    }

    public String getPlatformName();

    public boolean isModLoaded(String var1);

    public boolean isDevelopmentEnvironment();

    public boolean isDataGen();

    public List<Mod> getMods();

    public Optional<Mod> getMod(String var1);

    public IItemStack createMCItemStack(ItemStack var1);

    public IItemStack createMCItemStackMutable(ItemStack var1);

    public IItemStack getEmptyIItemStack();

    public RecipeSerializer<ScriptRecipe> getScriptSerializer();

    public Fluid getBucketContent(BucketItem var1);

    public Path getGameDirectory();

    default public Path getPathFromGameDirectory(Path path) {
        return this.getGameDirectory().resolve(path);
    }

    default public Path getPathFromGameDirectory(String path) {
        return this.getPathFromGameDirectory(Path.of(path, new String[0]));
    }

    default public Path getRelativePathFromGameDirectory(Path path) {
        return this.getGameDirectory().toAbsolutePath().relativize(path.toAbsolutePath());
    }

    default public Path getRelativePathFromGameDirectory(String path) {
        return this.getRelativePathFromGameDirectory(Path.of(path, new String[0]));
    }

    default public <T extends Annotation> Stream<? extends Class<?>> findClassesWithAnnotation(Class<T> annotationCls) {
        return this.findClassesWithAnnotation(annotationCls, mod -> {}, tMapEither -> true);
    }

    default public <T extends Annotation> Stream<? extends Class<?>> findClassesWithAnnotation(Class<T> annotationCls, Consumer<Mod> consumer) {
        return this.findClassesWithAnnotation(annotationCls, consumer, tMapEither -> true);
    }

    public <T extends Annotation> Stream<? extends Class<?>> findClassesWithAnnotation(Class<T> var1, Consumer<Mod> var2, Predicate<Either<T, Map<String, Object>>> var3);

    public Method findMethod(@Nonnull Class<?> var1, @Nonnull String var2, @Nonnull Class<?> var3, Class<?> ... var4);

    public <T> Field findField(@Nonnull Class<? super T> var1, @Nonnull String var2, @Nonnull String var3);

    default public void registerCustomTradeConverters(Map<Class<? extends VillagerTrades.ItemListing>, Function<VillagerTrades.ItemListing, CTTradeObject>> classFunctionMap) {
    }

    public Map<ResourceLocation, ILootModifier> getLootModifiersMap();

    public IInventoryWrapper getPlayerInventory(Player var1);

    default public boolean canItemStacksStack(ItemStack first, ItemStack second) {
        if (first.isEmpty() || !first.sameItem(second) || first.hasTag() != second.hasTag()) {
            return false;
        }
        return !first.hasTag() || first.getTag().equals((Object)second.getTag());
    }

    public boolean doCraftingTableRecipesConflict(IRecipeManager var1, Recipe<?> var2, Recipe<?> var3);

    public Set<MutableComponent> getFluidsForDump(ItemStack var1, Player var2, InteractionHand var3);

    public CompoundTag getCustomData(Entity var1);

    public CompoundTag getPersistentData(ServerPlayer var1);

    default public void addFoodPropertiesEffect(FoodProperties internal, MobEffectInstance effect, float probability) {
        internal.getEffects().add(Pair.of((Object)effect, (Object)Float.valueOf(probability)));
    }

    default public void removeFoodPropertiesEffect(FoodProperties internal, MobEffectInstance effect) {
        internal.getEffects().removeIf(pair -> ((MobEffectInstance)pair.getFirst()).equals((Object)effect));
    }

    default public void removeFoodPropertiesEffect(FoodProperties internal, MobEffect effect) {
        internal.getEffects().removeIf(pair -> ((MobEffectInstance)pair.getFirst()).getEffect() == effect);
    }

    default public void invalidateIngredients(List<Ingredient> ingredients) {
        ingredients.forEach(ingredient -> ((AccessIngredient)ingredient).crafttweaker$setItemStacks(null));
        ingredients.clear();
    }
}

