/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.platform.services;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.command.CommandUtilities;
import com.blamejared.crafttweaker.api.data.MapData;
import com.blamejared.crafttweaker.api.data.base.visitor.DataToTextComponentVisitor;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.item.attribute.ItemAttributeModifierBase;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker.api.recipe.replacement.event.IGatherReplacementExclusionEvent;
import com.blamejared.crafttweaker.api.util.AttributeUtil;
import com.blamejared.crafttweaker.natives.block.ExpandBlock;
import com.blamejared.crafttweaker.natives.block.ExpandBlockState;
import com.blamejared.crafttweaker.natives.entity.ExpandEntity;
import com.blamejared.crafttweaker.natives.entity.ExpandEntityType;
import com.blamejared.crafttweaker.natives.entity.type.player.ExpandPlayer;
import com.blamejared.crafttweaker.natives.world.ExpandLevel;
import com.blamejared.crafttweaker.platform.Services;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public interface IEventHelper {
    public static final Map<RecipeType<?>, List<Pair<IIngredient, Integer>>> BURN_TIMES = new HashMap();
    public static final Set<Player> BLOCK_INFO_PLAYERS = new HashSet<Player>();
    public static final Set<Player> ENTITY_INFO_PLAYERS = new HashSet<Player>();
    public static final Map<IIngredient, List<Consumer<ItemAttributeModifierBase>>> ATTRIBUTE_MODIFIERS = new HashMap<IIngredient, List<Consumer<ItemAttributeModifierBase>>>();

    public IGatherReplacementExclusionEvent fireGatherReplacementExclusionEvent(IRecipeManager<?> var1);

    default public void setBurnTime(IIngredient ingredient, int burnTime, RecipeType<?> type) {
        this.getBurnTimes().computeIfAbsent(type, recipeType -> new ArrayList()).add(Pair.of((Object)ingredient, (Object)burnTime));
    }

    public int getBurnTime(IItemStack var1);

    default public Map<RecipeType<?>, List<Pair<IIngredient, Integer>>> getBurnTimes() {
        return BURN_TIMES;
    }

    default public Map<IIngredient, List<Consumer<ItemAttributeModifierBase>>> getAttributeModifiers() {
        return ATTRIBUTE_MODIFIERS;
    }

    default public void applyAttributeModifiers(ItemAttributeModifierBase modifierBase) {
        CompoundTag crtData;
        ItemStack stack = modifierBase.getItemStack();
        if (stack.hasTag() && (crtData = stack.getTagElement("CraftTweakerData")) != null) {
            AttributeUtil.getAttributeModifiers(stack, modifierBase.getSlotType()).forEach((attribute, modifiers) -> modifiers.forEach(modifier -> {
                if (modifierBase.getModifiers().containsEntry(attribute, modifier)) {
                    modifierBase.removeModifier((Attribute)attribute, (AttributeModifier)modifier);
                }
                modifierBase.addModifier((Attribute)attribute, (AttributeModifier)modifier);
            }));
        }
        IItemStack keyStack = Services.PLATFORM.createMCItemStack(stack);
        for (Map.Entry<IIngredient, List<Consumer<ItemAttributeModifierBase>>> entry : Services.EVENT.getAttributeModifiers().entrySet()) {
            if (!entry.getKey().matches(keyStack)) continue;
            for (Consumer<ItemAttributeModifierBase> modifiers2 : entry.getValue()) {
                modifiers2.accept(modifierBase);
            }
        }
    }

    default public boolean onBlockInteract(Player player, InteractionHand hand, BlockHitResult hitResult) {
        Level world = player.level;
        BlockPos pos = hitResult.getBlockPos();
        if (BLOCK_INFO_PLAYERS.contains(player)) {
            if (!world.isClientSide() && hand == InteractionHand.MAIN_HAND) {
                MapData tileData;
                BlockState state = world.getBlockState(pos);
                IEventHelper.sendAndLog(player, (MutableComponent)new TranslatableComponent("crafttweaker.command.info.block.name", new Object[]{Services.REGISTRY.getRegistryKey(state.getBlock())}));
                String blockCS = ExpandBlock.getCommandString(state.getBlock());
                String blockStateCS = ExpandBlockState.getCommandString(state);
                CommandUtilities.sendCopying(new TranslatableComponent("crafttweaker.command.misc.block").append(": ").append((Component)new TextComponent(blockCS).withStyle(ChatFormatting.GREEN)), blockCS, player);
                CommandUtilities.sendCopying(new TranslatableComponent("crafttweaker.command.misc.blockstate").append(": ").append((Component)new TextComponent(blockStateCS).withStyle(ChatFormatting.GREEN)), blockStateCS, player);
                if (!state.getProperties().isEmpty()) {
                    IEventHelper.sendAndLog(player, (MutableComponent)new TranslatableComponent("crafttweaker.command.info.block.properties"));
                    state.getProperties().forEach(property -> IEventHelper.sendAndLog(player, new TextComponent("    " + property.getName()).withStyle(ChatFormatting.YELLOW).append((Component)new TextComponent(": ").withStyle(ChatFormatting.WHITE)).append((Component)new TextComponent(state.getValue(property).toString()).withStyle(ChatFormatting.AQUA))));
                }
                if (!(tileData = ExpandLevel.getBlockEntityData(world, pos)).isEmpty()) {
                    IEventHelper.sendAndLog(player, (MutableComponent)new TranslatableComponent("crafttweaker.command.info.block.entity.data", new Object[]{tileData.accept(new DataToTextComponentVisitor("    ", 0))}));
                }
            }
            return true;
        }
        return false;
    }

    default public boolean onEntityInteract(Player player, InteractionHand hand, Entity target) {
        Level world = player.level;
        if (ENTITY_INFO_PLAYERS.contains(player)) {
            if (!world.isClientSide() && hand == InteractionHand.MAIN_HAND) {
                IEventHelper.sendAndLog(player, (MutableComponent)new TranslatableComponent("crafttweaker.command.info.entity.name", new Object[]{ExpandEntity.getName(target)}));
                IEventHelper.sendAndLog(player, (MutableComponent)new TranslatableComponent("crafttweaker.command.info.entity.type.bracket", new Object[]{ExpandEntityType.getCommandString(target.getType())}));
                MapData data = ExpandEntity.getData(target);
                if (!data.isEmpty()) {
                    IEventHelper.sendAndLog(player, (MutableComponent)new TranslatableComponent("crafttweaker.command.info.entity.data", new Object[]{data.accept(new DataToTextComponentVisitor("    ", 0))}));
                }
            }
            return true;
        }
        return false;
    }

    private static void sendAndLog(Player player, MutableComponent component) {
        ExpandPlayer.sendMessage(player, (Component)component);
        CraftTweakerAPI.LOGGER.info(component.getString());
    }
}

