/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.natives.predicate.builder;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import com.blamejared.crafttweaker_annotations.annotations.NativeTypeRegistration;
import java.util.Map;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.PlayerPredicate;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.Stat;
import net.minecraft.stats.StatType;
import net.minecraft.world.level.GameType;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@Document(value="vanilla/api/predicate/builder/PlayerPredicateBuilder")
@NativeTypeRegistration(value=PlayerPredicate.Builder.class, zenCodeName="crafttweaker.api.predicate.builder.PlayerPredicateBuilder")
public final class ExpandPlayerPredicateBuilder {
    @ZenCodeType.Method
    public static PlayerPredicate.Builder level(PlayerPredicate.Builder internal, MinMaxBounds.Ints level) {
        return internal.setLevel(level);
    }

    @ZenCodeType.Method
    public static PlayerPredicate.Builder statistic(PlayerPredicate.Builder internal, ResourceLocation type, ResourceLocation name, MinMaxBounds.Ints value) {
        StatType statType = (StatType)Registry.STAT_TYPE.getOrThrow(ResourceKey.create((ResourceKey)Registry.STAT_TYPE_REGISTRY, (ResourceLocation)type));
        return internal.addStat(ExpandPlayerPredicateBuilder.statistic(statType, name), value);
    }

    @ZenCodeType.Method
    public static PlayerPredicate.Builder statistic(PlayerPredicate.Builder internal, ResourceLocation type, String name, MinMaxBounds.Ints value) {
        return ExpandPlayerPredicateBuilder.statistic(internal, type, new ResourceLocation(name), value);
    }

    @ZenCodeType.Method
    public static PlayerPredicate.Builder statistic(PlayerPredicate.Builder internal, String type, ResourceLocation name, MinMaxBounds.Ints value) {
        return ExpandPlayerPredicateBuilder.statistic(internal, new ResourceLocation(type), name, value);
    }

    @ZenCodeType.Method
    public static PlayerPredicate.Builder statistic(PlayerPredicate.Builder internal, String type, String name, MinMaxBounds.Ints value) {
        return ExpandPlayerPredicateBuilder.statistic(internal, type, new ResourceLocation(name), value);
    }

    @ZenCodeType.Method
    public static PlayerPredicate.Builder recipe(PlayerPredicate.Builder internal, ResourceLocation name, @ZenCodeType.OptionalBoolean(value=true) boolean unlocked) {
        return internal.addRecipe(name, unlocked);
    }

    @ZenCodeType.Method
    public static PlayerPredicate.Builder recipe(PlayerPredicate.Builder internal, String name, @ZenCodeType.OptionalBoolean(value=true) boolean unlocked) {
        return ExpandPlayerPredicateBuilder.recipe(internal, new ResourceLocation(name), unlocked);
    }

    @ZenCodeType.Method
    public static PlayerPredicate.Builder gameType(PlayerPredicate.Builder internal, GameType type) {
        return internal.setGameType(type);
    }

    @ZenCodeType.Method
    public static PlayerPredicate.Builder lookingAt(PlayerPredicate.Builder internal, EntityPredicate predicate) {
        return internal.setLookingAt(predicate);
    }

    @ZenCodeType.Method
    public static PlayerPredicate.Builder lookingAt(PlayerPredicate.Builder internal, EntityPredicate.Builder predicate) {
        return ExpandPlayerPredicateBuilder.lookingAt(internal, predicate.build());
    }

    @ZenCodeType.Method
    public static PlayerPredicate.Builder advancement(PlayerPredicate.Builder internal, ResourceLocation name, @ZenCodeType.OptionalBoolean(value=true) boolean completed) {
        return internal.checkAdvancementDone(name, completed);
    }

    @ZenCodeType.Method
    public static PlayerPredicate.Builder advancement(PlayerPredicate.Builder internal, String name, @ZenCodeType.OptionalBoolean(value=true) boolean completed) {
        return ExpandPlayerPredicateBuilder.advancement(internal, new ResourceLocation(name), completed);
    }

    @ZenCodeType.Method
    public static PlayerPredicate.Builder advancementCriteria(PlayerPredicate.Builder internal, ResourceLocation name, Map<String, Boolean> criteria) {
        return internal.checkAdvancementCriterions(name, criteria);
    }

    @ZenCodeType.Method
    public static PlayerPredicate.Builder advancementCriteria(PlayerPredicate.Builder internal, String name, Map<String, Boolean> criteria) {
        return ExpandPlayerPredicateBuilder.advancementCriteria(internal, new ResourceLocation(name), criteria);
    }

    @ZenCodeType.Method
    public static PlayerPredicate.Builder advancementCriterion(PlayerPredicate.Builder internal, ResourceLocation name, String criterion, @ZenCodeType.OptionalBoolean(value=true) boolean completed) {
        return ExpandPlayerPredicateBuilder.advancementCriteria(internal, name, Map.of(criterion, completed));
    }

    @ZenCodeType.Method
    public static PlayerPredicate.Builder advancementCriterion(PlayerPredicate.Builder internal, String name, String criterion, @ZenCodeType.OptionalBoolean(value=true) boolean completed) {
        return ExpandPlayerPredicateBuilder.advancementCriterion(internal, new ResourceLocation(name), criterion, completed);
    }

    @ZenCodeType.Method
    public static PlayerPredicate build(PlayerPredicate.Builder internal) {
        return internal.build();
    }

    private static <T> Stat<T> statistic(StatType<T> type, ResourceLocation name) {
        return type.get(type.getRegistry().getOrThrow(ResourceKey.create((ResourceKey)type.getRegistry().key(), (ResourceLocation)name)));
    }
}

