/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.natives.block.material;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import com.blamejared.crafttweaker_annotations.annotations.NativeTypeRegistration;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Locale;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.level.material.PushReaction;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@Document(value="vanilla/api/block/material/Material")
@NativeTypeRegistration(value=Material.class, zenCodeName="crafttweaker.api.block.material.Material")
public class ExpandMaterial {
    public static final BiMap<String, Material> VANILLA_MATERIALS = (BiMap)Util.make((Object)HashBiMap.create(), map -> {
        map.put((Object)"AIR", (Object)Material.AIR);
        map.put((Object)"STRUCTURAL_AIR", (Object)Material.STRUCTURAL_AIR);
        map.put((Object)"PORTAL", (Object)Material.PORTAL);
        map.put((Object)"CLOTH_DECORATION", (Object)Material.CLOTH_DECORATION);
        map.put((Object)"PLANT", (Object)Material.PLANT);
        map.put((Object)"WATER_PLANT", (Object)Material.WATER_PLANT);
        map.put((Object)"REPLACEABLE_PLANT", (Object)Material.REPLACEABLE_PLANT);
        map.put((Object)"REPLACEABLE_FIREPROOF_PLANT", (Object)Material.REPLACEABLE_FIREPROOF_PLANT);
        map.put((Object)"REPLACEABLE_WATER_PLANT", (Object)Material.REPLACEABLE_WATER_PLANT);
        map.put((Object)"WATER", (Object)Material.WATER);
        map.put((Object)"BUBBLE_COLUMN", (Object)Material.BUBBLE_COLUMN);
        map.put((Object)"LAVA", (Object)Material.LAVA);
        map.put((Object)"TOP_SNOW", (Object)Material.TOP_SNOW);
        map.put((Object)"FIRE", (Object)Material.FIRE);
        map.put((Object)"DECORATION", (Object)Material.DECORATION);
        map.put((Object)"WEB", (Object)Material.WEB);
        map.put((Object)"SCULK", (Object)Material.SCULK);
        map.put((Object)"BUILDABLE_GLASS", (Object)Material.BUILDABLE_GLASS);
        map.put((Object)"CLAY", (Object)Material.CLAY);
        map.put((Object)"DIRT", (Object)Material.DIRT);
        map.put((Object)"GRASS", (Object)Material.GRASS);
        map.put((Object)"ICE_SOLID", (Object)Material.ICE_SOLID);
        map.put((Object)"SAND", (Object)Material.SAND);
        map.put((Object)"SPONGE", (Object)Material.SPONGE);
        map.put((Object)"SHULKER_SHELL", (Object)Material.SHULKER_SHELL);
        map.put((Object)"WOOD", (Object)Material.WOOD);
        map.put((Object)"NETHER_WOOD", (Object)Material.NETHER_WOOD);
        map.put((Object)"BAMBOO_SAPLING", (Object)Material.BAMBOO_SAPLING);
        map.put((Object)"BAMBOO", (Object)Material.BAMBOO);
        map.put((Object)"WOOL", (Object)Material.WOOL);
        map.put((Object)"EXPLOSIVE", (Object)Material.EXPLOSIVE);
        map.put((Object)"LEAVES", (Object)Material.LEAVES);
        map.put((Object)"GLASS", (Object)Material.GLASS);
        map.put((Object)"ICE", (Object)Material.ICE);
        map.put((Object)"CACTUS", (Object)Material.CACTUS);
        map.put((Object)"STONE", (Object)Material.STONE);
        map.put((Object)"METAL", (Object)Material.METAL);
        map.put((Object)"SNOW", (Object)Material.SNOW);
        map.put((Object)"HEAVY_METAL", (Object)Material.HEAVY_METAL);
        map.put((Object)"BARRIER", (Object)Material.BARRIER);
        map.put((Object)"PISTON", (Object)Material.PISTON);
        map.put((Object)"MOSS", (Object)Material.MOSS);
        map.put((Object)"VEGETABLE", (Object)Material.VEGETABLE);
        map.put((Object)"EGG", (Object)Material.EGG);
        map.put((Object)"CAKE", (Object)Material.CAKE);
        map.put((Object)"AMETHYST", (Object)Material.AMETHYST);
        map.put((Object)"POWDER_SNOW", (Object)Material.POWDER_SNOW);
    });

    public static Optional<Material> getOptionalMaterial(String tokens) {
        return Optional.ofNullable((Material)VANILLA_MATERIALS.get((Object)tokens));
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="isLiquid")
    public static boolean isLiquid(Material internal) {
        return internal.isLiquid();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="isSolid")
    public static boolean isSolid(Material internal) {
        return internal.isSolid();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="blocksMotion")
    public static boolean blocksMotion(Material internal) {
        return internal.blocksMotion();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="isFlammable")
    public static boolean isFlammable(Material internal) {
        return internal.isFlammable();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="isReplaceable")
    public static boolean isReplaceable(Material internal) {
        return internal.isReplaceable();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="isSolidBlocking")
    public static boolean isSolidBlocking(Material internal) {
        return internal.isSolidBlocking();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="pushReaction")
    public static PushReaction getPushReaction(Material internal) {
        return internal.getPushReaction();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="color")
    public static MaterialColor getColor(Material internal) {
        return internal.getColor();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="commandString")
    public static String getCommandString(Material internal) {
        BiMap inverse = VANILLA_MATERIALS.inverse();
        String name = (String)inverse.getOrDefault((Object)internal, (Object)"UNKNOWN");
        return "<material:" + name.toLowerCase(Locale.ROOT) + ">";
    }
}

