/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.natives.block;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.action.block.ActionSetBlockProperty;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.block.CTBlockIngredient;
import com.blamejared.crafttweaker.mixin.common.access.block.AccessBlockBehaviour;
import com.blamejared.crafttweaker.natives.block.material.ExpandMaterial;
import com.blamejared.crafttweaker.platform.Services;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import com.blamejared.crafttweaker_annotations.annotations.NativeTypeRegistration;
import com.blamejared.crafttweaker_annotations.annotations.TaggableElement;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@Document(value="vanilla/api/block/Block")
@NativeTypeRegistration(value=Block.class, zenCodeName="crafttweaker.api.block.Block")
@TaggableElement(value="minecraft:block")
public class ExpandBlock {
    @ZenCodeType.Method
    @ZenCodeType.Getter(value="registryName")
    public static ResourceLocation getRegistryName(Block internal) {
        return Services.REGISTRY.getRegistryKey(internal);
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="defaultState")
    public static BlockState getDefaultState(Block internal) {
        return internal.defaultBlockState();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="lootTable")
    public static String getLootTable(Block internal) {
        return internal.getLootTable().toString();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="isPossibleToRespawnInThis")
    public static boolean isPossibleToRespawnInThis(Block internal) {
        return internal.isPossibleToRespawnInThis();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="descriptionId")
    public static String getDescriptionId(Block internal) {
        return internal.getDescriptionId();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="name")
    public static MutableComponent getName(Block internal) {
        return internal.getName();
    }

    @ZenCodeType.Method
    @ZenCodeType.Caster
    @ZenCodeType.Getter(value="commandString")
    public static String getCommandString(Block internal) {
        return "<block:" + ExpandBlock.getRegistryName(internal) + ">";
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="possibleStates")
    public static List<BlockState> getPossibleStates(Block internal) {
        return internal.getStateDefinition().getPossibleStates();
    }

    @ZenCodeType.Method
    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.EQUALS)
    public static boolean matches(Block internal, Block other) {
        return internal == other;
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="friction")
    public static float getFriction(Block internal) {
        return ((AccessBlockBehaviour)internal).crafttweaker$getFriction();
    }

    @ZenCodeType.Method
    @ZenCodeType.Setter(value="friction")
    public static void setFriction(Block internal, float friction) {
        CraftTweakerAPI.apply(new ActionSetBlockProperty<Float>(internal, "Friction", Float.valueOf(friction), Float.valueOf(((AccessBlockBehaviour)internal).crafttweaker$getFriction()), ((AccessBlockBehaviour)internal)::crafttweaker$setFriction));
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="speedFactor")
    public static float getSpeedFactor(Block internal) {
        return internal.getSpeedFactor();
    }

    @ZenCodeType.Method
    @ZenCodeType.Setter(value="speedFactor")
    public static void setSpeedFactor(Block internal, float speedFactor) {
        CraftTweakerAPI.apply(new ActionSetBlockProperty<Float>(internal, "Speed Factor", Float.valueOf(speedFactor), Float.valueOf(((AccessBlockBehaviour)internal).crafttweaker$getSpeedFactor()), ((AccessBlockBehaviour)internal)::crafttweaker$setSpeedFactor));
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="jumpFactor")
    public static float getJumpFactor(Block internal) {
        return internal.getJumpFactor();
    }

    @ZenCodeType.Method
    @ZenCodeType.Setter(value="jumpFactor")
    public static void setJumpFactor(Block internal, float jumpFactor) {
        CraftTweakerAPI.apply(new ActionSetBlockProperty<Float>(internal, "Jump Factor", Float.valueOf(jumpFactor), Float.valueOf(((AccessBlockBehaviour)internal).crafttweaker$getJumpFactor()), ((AccessBlockBehaviour)internal)::crafttweaker$setJumpFactor));
    }

    @ZenCodeType.Method
    @ZenCodeType.Caster
    public static Item asItem(Block internal) {
        return internal.asItem();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="dynamicShape")
    public static boolean hasDynamicShape(Block internal) {
        return internal.hasDynamicShape();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="hasCollision")
    public static boolean hasCollision(Block internal) {
        return ((AccessBlockBehaviour)internal).crafttweaker$getHasCollision();
    }

    @ZenCodeType.Method
    @ZenCodeType.Setter(value="hasCollision")
    public static void setHasCollision(Block internal, boolean canCollide) {
        CraftTweakerAPI.apply(new ActionSetBlockProperty<Boolean>(internal, "Has Collision", Boolean.valueOf(canCollide), Boolean.valueOf(((AccessBlockBehaviour)internal).crafttweaker$getHasCollision()), ((AccessBlockBehaviour)internal)::crafttweaker$setHasCollision));
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="explosionResistance")
    public static float getExplosionResistance(Block internal) {
        return ((AccessBlockBehaviour)internal).crafttweaker$getExplosionResistance();
    }

    @ZenCodeType.Method
    @ZenCodeType.Setter(value="explosionResistance")
    public static void setExplosionResistance(Block internal, float resistance) {
        CraftTweakerAPI.apply(new ActionSetBlockProperty<Float>(internal, "Explosion Resistance", Float.valueOf(resistance), Float.valueOf(((AccessBlockBehaviour)internal).crafttweaker$getExplosionResistance()), ((AccessBlockBehaviour)internal)::crafttweaker$setExplosionResistance));
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="material")
    public static Material getMaterial(Block internal) {
        return ((AccessBlockBehaviour)internal).crafttweaker$getMaterial();
    }

    @ZenCodeType.Method
    @ZenCodeType.Setter(value="material")
    public static void setMaterial(Block internal, Material material) {
        CraftTweakerAPI.apply(new ActionSetBlockProperty<Material>(internal, "Material", material, ((AccessBlockBehaviour)internal).crafttweaker$getMaterial(), ((AccessBlockBehaviour)internal)::crafttweaker$setMaterial, ExpandMaterial::getCommandString));
    }

    @ZenCodeType.Caster(implicit=true)
    public static CTBlockIngredient asBlockIngredient(Block internal) {
        return new CTBlockIngredient.BlockIngredient(internal);
    }

    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.OR)
    public static CTBlockIngredient asList(Block internal, CTBlockIngredient other) {
        ArrayList<CTBlockIngredient> elements = new ArrayList<CTBlockIngredient>();
        elements.add(ExpandBlock.asBlockIngredient(internal));
        elements.add(other);
        return new CTBlockIngredient.CompoundBlockIngredient(elements);
    }
}

