/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.script;

import com.blamejared.crafttweaker.impl.script.ScriptRecipe;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import java.util.LinkedList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeSerializer;

public interface IScriptSerializer
extends RecipeSerializer<ScriptRecipe> {
    default public ScriptRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
        return new ScriptRecipe(recipeId, json.get("fileName").getAsString(), json.get("content").getAsString());
    }

    default public ScriptRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
        String fileName = buffer.readUtf();
        int parts = buffer.readVarInt();
        StringBuilder script = new StringBuilder();
        while (parts-- > 0) {
            script.append(buffer.readUtf());
        }
        return new ScriptRecipe(recipeId, fileName, script.toString());
    }

    default public void toNetwork(FriendlyByteBuf buffer, ScriptRecipe recipe) {
        String contents = recipe.getContent();
        LinkedList split = Lists.newLinkedList((Iterable)Splitter.fixedLength((int)4095).split((CharSequence)contents));
        buffer.writeUtf(recipe.getFileName());
        buffer.writeVarInt(split.size());
        split.forEach(arg_0 -> ((FriendlyByteBuf)buffer).writeUtf(arg_0));
    }
}

