/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.recipe.handler.type.vanilla;

import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.recipe.handler.IRecipeHandler;
import com.blamejared.crafttweaker.api.recipe.handler.IReplacementRule;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker.api.util.IngredientUtil;
import com.blamejared.crafttweaker.api.util.ItemStackUtil;
import com.blamejared.crafttweaker.api.util.StringUtil;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.BlastingRecipe;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.item.crafting.SmokingRecipe;

@IRecipeHandler.For.Container(value={@IRecipeHandler.For(value=BlastingRecipe.class), @IRecipeHandler.For(value=CampfireCookingRecipe.class), @IRecipeHandler.For(value=SmeltingRecipe.class), @IRecipeHandler.For(value=SmokingRecipe.class)})
public final class CookingRecipeHandler
implements IRecipeHandler<AbstractCookingRecipe> {
    private static final Map<RecipeType<?>, Pair<String, CookingRecipeFactory<?>>> LOOKUP = ImmutableMap.builder().put((Object)RecipeType.BLASTING, (Object)Pair.of((Object)"blastFurnace", BlastingRecipe::new)).put((Object)RecipeType.CAMPFIRE_COOKING, (Object)Pair.of((Object)"campfire", CampfireCookingRecipe::new)).put((Object)RecipeType.SMELTING, (Object)Pair.of((Object)"furnace", SmeltingRecipe::new)).put((Object)RecipeType.SMOKING, (Object)Pair.of((Object)"smoker", SmokingRecipe::new)).build();

    @Override
    public String dumpToCommandString(IRecipeManager manager, AbstractCookingRecipe recipe) {
        return String.format("%s.addRecipe(%s, %s, %s, %s, %s);", LOOKUP.get(recipe.getType()).getFirst(), StringUtil.quoteAndEscape(recipe.getId()), ItemStackUtil.getCommandString(recipe.getResultItem()), IIngredient.fromIngredient((Ingredient)recipe.getIngredients().get(0)).getCommandString(), Float.valueOf(recipe.getExperience()), recipe.getCookingTime());
    }

    @Override
    public Optional<Function<ResourceLocation, AbstractCookingRecipe>> replaceIngredients(IRecipeManager manager, AbstractCookingRecipe recipe, List<IReplacementRule> rules) {
        return IRecipeHandler.attemptReplacing((Ingredient)recipe.getIngredients().get(0), Ingredient.class, recipe, rules).map(input -> id -> ((CookingRecipeFactory)LOOKUP.get(recipe.getType()).getSecond()).create((ResourceLocation)id, recipe.getGroup(), (Ingredient)input, recipe.getResultItem(), recipe.getExperience(), recipe.getCookingTime()));
    }

    @Override
    public <U extends Recipe<?>> boolean doesConflict(IRecipeManager manager, AbstractCookingRecipe firstRecipe, U secondRecipe) {
        return IngredientUtil.canConflict((Ingredient)firstRecipe.getIngredients().get(0), (Ingredient)secondRecipe.getIngredients().get(0));
    }

    @FunctionalInterface
    private static interface CookingRecipeFactory<T extends AbstractCookingRecipe> {
        public T create(ResourceLocation var1, String var2, Ingredient var3, ItemStack var4, float var5, int var6);
    }
}

