/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.plugin.crafttweaker;

import com.blamejared.crafttweaker.api.CraftTweakerConstants;
import com.blamejared.crafttweaker.api.bracket.custom.EnumConstantBracketHandler;
import com.blamejared.crafttweaker.api.bracket.custom.RecipeTypeBracketHandler;
import com.blamejared.crafttweaker.api.bracket.custom.TagBracketHandler;
import com.blamejared.crafttweaker.api.bracket.custom.TagManagerBracketHandler;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.plugin.CraftTweakerPlugin;
import com.blamejared.crafttweaker.api.plugin.IBracketParserRegistrationHandler;
import com.blamejared.crafttweaker.api.plugin.ICommandRegistrationHandler;
import com.blamejared.crafttweaker.api.plugin.ICraftTweakerPlugin;
import com.blamejared.crafttweaker.api.plugin.IJavaNativeIntegrationRegistrationHandler;
import com.blamejared.crafttweaker.api.plugin.ILoaderRegistrationHandler;
import com.blamejared.crafttweaker.api.plugin.IRecipeHandlerRegistrationHandler;
import com.blamejared.crafttweaker.api.plugin.IScriptLoadSourceRegistrationHandler;
import com.blamejared.crafttweaker.api.plugin.IScriptRunModuleConfiguratorRegistrationHandler;
import com.blamejared.crafttweaker.api.plugin.ITaggableElementRegistrationHandler;
import com.blamejared.crafttweaker.api.plugin.IVillagerTradeRegistrationHandler;
import com.blamejared.crafttweaker.api.villager.CTTradeObject;
import com.blamejared.crafttweaker.api.zencode.scriptrun.IScriptRunModuleConfigurator;
import com.blamejared.crafttweaker.impl.command.type.DumpCommands;
import com.blamejared.crafttweaker.impl.command.type.HandCommands;
import com.blamejared.crafttweaker.impl.command.type.InventoryCommands;
import com.blamejared.crafttweaker.impl.command.type.MiscCommands;
import com.blamejared.crafttweaker.impl.command.type.ModCommands;
import com.blamejared.crafttweaker.impl.command.type.RecipeCommands;
import com.blamejared.crafttweaker.impl.command.type.conflict.ConflictCommand;
import com.blamejared.crafttweaker.impl.command.type.script.ScriptCommands;
import com.blamejared.crafttweaker.impl.command.type.script.example.ExamplesCommand;
import com.blamejared.crafttweaker.impl.plugin.crafttweaker.BracketParserRegistrationManager;
import com.blamejared.crafttweaker.impl.plugin.crafttweaker.EnumBracketParserRegistrationManager;
import com.blamejared.crafttweaker.impl.plugin.crafttweaker.RecipeHandlerGatherer;
import com.blamejared.crafttweaker.impl.plugin.crafttweaker.TaggableElementsRegistrationManager;
import com.blamejared.crafttweaker.impl.plugin.crafttweaker.ZenClassGatherer;
import com.blamejared.crafttweaker.impl.plugin.crafttweaker.ZenClassRegistrationManager;
import com.blamejared.crafttweaker.mixin.common.access.villager.AccessDyedArmorForEmeralds;
import com.blamejared.crafttweaker.mixin.common.access.villager.AccessEmeraldForItems;
import com.blamejared.crafttweaker.mixin.common.access.villager.AccessEnchantedItemForEmeralds;
import com.blamejared.crafttweaker.mixin.common.access.villager.AccessItemsAndEmeraldsToItems;
import com.blamejared.crafttweaker.mixin.common.access.villager.AccessItemsForEmeralds;
import com.blamejared.crafttweaker.mixin.common.access.villager.AccessTippedArrowForItemsAndEmeralds;
import com.blamejared.crafttweaker.platform.Services;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

@CraftTweakerPlugin(value="crafttweaker:builtin")
public final class BuiltinCraftTweakerPlugin
implements ICraftTweakerPlugin {
    private final BracketParserRegistrationManager bracketParserRegistrationManager = new BracketParserRegistrationManager();
    private final EnumBracketParserRegistrationManager enumBracketParserRegistrationManager = new EnumBracketParserRegistrationManager();
    private final RecipeHandlerGatherer handlerGatherer = new RecipeHandlerGatherer();
    private final TaggableElementsRegistrationManager taggableElementsRegistrationManager = new TaggableElementsRegistrationManager();
    private final ZenClassGatherer zenGatherer = new ZenClassGatherer();
    private final ZenClassRegistrationManager zenClassRegistrationManager = new ZenClassRegistrationManager();

    @Override
    public void registerLoaders(ILoaderRegistrationHandler handler) {
        handler.registerLoader("initialize", new String[0]);
        handler.registerLoader("crafttweaker", new String[0]);
        handler.registerLoader("tags", new String[0]);
    }

    @Override
    public void registerLoadSource(IScriptLoadSourceRegistrationHandler handler) {
        handler.registerLoadSource(CraftTweakerConstants.RELOAD_LISTENER_SOURCE_ID);
        handler.registerLoadSource(CraftTweakerConstants.CLIENT_RECIPES_UPDATED_SOURCE_ID);
    }

    @Override
    public void registerModuleConfigurators(IScriptRunModuleConfiguratorRegistrationHandler handler) {
        IScriptRunModuleConfigurator defaultConfig = IScriptRunModuleConfigurator.createDefault("crafttweaker");
        handler.registerConfigurator("crafttweaker", defaultConfig);
        handler.registerConfigurator("initialize", defaultConfig);
        handler.registerConfigurator("tags", defaultConfig);
    }

    @Override
    public void manageJavaNativeIntegration(IJavaNativeIntegrationRegistrationHandler handler) {
        this.zenGatherer.listProviders();
        this.zenGatherer.onCandidates(candidate -> this.zenClassRegistrationManager.attemptRegistration(candidate.loader(), candidate.clazz(), handler));
        this.zenClassRegistrationManager.attemptDeferredRegistration(handler);
    }

    @Override
    public void registerBracketParsers(IBracketParserRegistrationHandler handler) {
        this.zenGatherer.onCandidates(candidate -> {
            this.bracketParserRegistrationManager.addRegistrationCandidate(candidate.clazz(), candidate.loader());
            this.enumBracketParserRegistrationManager.attemptRegistration(candidate.clazz(), candidate.loader(), handler);
        });
        this.bracketParserRegistrationManager.attemptRegistration(handler);
        handler.registerParserFor("*", "constant", new EnumConstantBracketHandler(), new IBracketParserRegistrationHandler.DumperData("constant", EnumConstantBracketHandler.getDumperData()));
        handler.registerParserFor("crafttweaker", "recipetype", new RecipeTypeBracketHandler(), new IBracketParserRegistrationHandler.DumperData("recipetype", RecipeTypeBracketHandler.getDumperData()));
        handler.registerParserFor("crafttweaker", "tag", new TagBracketHandler(), new IBracketParserRegistrationHandler.DumperData("tag", TagBracketHandler.getDumperData()));
        handler.registerParserFor("crafttweaker", "tagmanager", new TagManagerBracketHandler(), new IBracketParserRegistrationHandler.DumperData("tagmanager", TagManagerBracketHandler.getDumperData()));
        handler.registerParserFor("tags", "tag", new TagBracketHandler());
        handler.registerParserFor("tags", "tagmanager", new TagManagerBracketHandler());
    }

    @Override
    public void registerRecipeHandlers(IRecipeHandlerRegistrationHandler handler) {
        this.handlerGatherer.gatherAndRegisterHandlers(handler);
    }

    @Override
    public void registerVillagerTradeConverters(IVillagerTradeRegistrationHandler handler) {
        IItemStack emerald = Services.PLATFORM.createMCItemStackMutable(new ItemStack((ItemLike)Items.EMERALD));
        IItemStack compass = Services.PLATFORM.createMCItemStackMutable(new ItemStack((ItemLike)Items.COMPASS));
        IItemStack book = Services.PLATFORM.createMCItemStackMutable(new ItemStack((ItemLike)Items.BOOK));
        IItemStack enchantedBook = Services.PLATFORM.createMCItemStackMutable(new ItemStack((ItemLike)Items.ENCHANTED_BOOK));
        IItemStack filledMap = Services.PLATFORM.createMCItemStackMutable(new ItemStack((ItemLike)Items.FILLED_MAP));
        IItemStack suspiciousStew = Services.PLATFORM.createMCItemStackMutable(new ItemStack((ItemLike)Items.SUSPICIOUS_STEW));
        handler.registerTradeConverter(VillagerTrades.DyedArmorForEmeralds.class, trade -> new CTTradeObject(emerald, Services.PLATFORM.getEmptyIItemStack(), Services.PLATFORM.createMCItemStackMutable(((AccessDyedArmorForEmeralds)trade).crafttweaker$getItem().getDefaultInstance())));
        handler.registerTradeConverter(VillagerTrades.EmeraldForItems.class, trade -> new CTTradeObject(Services.PLATFORM.createMCItemStackMutable(((AccessEmeraldForItems)trade).crafttweaker$getItem().getDefaultInstance()), Services.PLATFORM.getEmptyIItemStack(), emerald));
        handler.registerTradeConverter(VillagerTrades.TreasureMapForEmeralds.class, trade -> new CTTradeObject(emerald, compass, filledMap));
        handler.registerTradeConverter(VillagerTrades.EmeraldsForVillagerTypeItem.class, trade -> new CTTradeObject(Services.PLATFORM.getEmptyIItemStack(), Services.PLATFORM.getEmptyIItemStack(), emerald));
        handler.registerTradeConverter(VillagerTrades.EnchantBookForEmeralds.class, trade -> new CTTradeObject(emerald, book, enchantedBook));
        handler.registerTradeConverter(VillagerTrades.EnchantedItemForEmeralds.class, trade -> new CTTradeObject(emerald, Services.PLATFORM.getEmptyIItemStack(), Services.PLATFORM.createMCItemStackMutable(((AccessEnchantedItemForEmeralds)trade).crafttweaker$getItemStack())));
        handler.registerTradeConverter(VillagerTrades.TippedArrowForItemsAndEmeralds.class, trade -> new CTTradeObject(emerald, Services.PLATFORM.createMCItemStackMutable(((AccessTippedArrowForItemsAndEmeralds)trade).crafttweaker$getFromItem().getDefaultInstance()), Services.PLATFORM.createMCItemStackMutable(((AccessTippedArrowForItemsAndEmeralds)trade).crafttweaker$getToItem())));
        handler.registerTradeConverter(VillagerTrades.ItemsAndEmeraldsToItems.class, trade -> new CTTradeObject(emerald, Services.PLATFORM.createMCItemStackMutable(((AccessItemsAndEmeraldsToItems)trade).crafttweaker$getFromItem()), Services.PLATFORM.createMCItemStackMutable(((AccessItemsAndEmeraldsToItems)trade).crafttweaker$getToItem())));
        handler.registerTradeConverter(VillagerTrades.ItemsForEmeralds.class, trade -> new CTTradeObject(emerald, Services.PLATFORM.getEmptyIItemStack(), Services.PLATFORM.createMCItemStackMutable(((AccessItemsForEmeralds)trade).crafttweaker$getItemStack())));
        handler.registerTradeConverter(VillagerTrades.SuspiciousStewForEmerald.class, trade -> new CTTradeObject(emerald, Services.PLATFORM.getEmptyIItemStack(), suspiciousStew));
    }

    @Override
    public void registerCommands(ICommandRegistrationHandler handler) {
        ConflictCommand.registerCommands(handler);
        DumpCommands.registerCommands(handler);
        InventoryCommands.registerCommands(handler);
        HandCommands.registerCommands(handler);
        ScriptCommands.registerCommands(handler);
        MiscCommands.registerCommands(handler);
        ModCommands.registerCommands(handler);
        RecipeCommands.registerCommands(handler);
        ExamplesCommand.registerCommand(handler);
        DumpCommands.registerDumpers(handler);
    }

    @Override
    public void registerTaggableElements(ITaggableElementRegistrationHandler handler) {
        this.zenGatherer.onCandidates(candidate -> this.taggableElementsRegistrationManager.attemptRegistration(candidate.clazz(), handler));
    }
}

