/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.command.type.conflict;

import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker.api.util.ItemStackUtil;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;

final class DescriptiveFilter
implements Predicate<Map.Entry<ResourceLocation, Recipe<?>>> {
    private final Predicate<Recipe<?>> delegate;
    private final MutableComponent description;

    private DescriptiveFilter(Predicate<Recipe<?>> delegate, MutableComponent description) {
        this.delegate = delegate;
        this.description = description;
    }

    static DescriptiveFilter of() {
        return new DescriptiveFilter(it -> true, (MutableComponent)new TextComponent(""));
    }

    static DescriptiveFilter of(IRecipeManager<?> manager) {
        RecipeType<?> type = manager.getRecipeType();
        return new DescriptiveFilter(it -> it.getType() == type, (MutableComponent)new TranslatableComponent("crafttweaker.command.conflict.description.type", new Object[]{manager.getCommandString()}));
    }

    static DescriptiveFilter of(ItemStack stack) {
        return new DescriptiveFilter(it -> ItemStackUtil.areStacksTheSame(it.getResultItem(), stack), (MutableComponent)new TranslatableComponent("crafttweaker.command.conflict.description.output", new Object[]{ItemStackUtil.getCommandString(stack)}));
    }

    @Override
    public boolean test(Map.Entry<ResourceLocation, Recipe<?>> recipe) {
        return this.delegate.test(recipe.getValue());
    }

    MutableComponent description() {
        return this.description;
    }
}

