/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.command.type.conflict;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.bracket.custom.RecipeTypeBracketHandler;
import com.blamejared.crafttweaker.api.command.CommandUtilities;
import com.blamejared.crafttweaker.api.command.argument.RecipeTypeArgument;
import com.blamejared.crafttweaker.api.plugin.ICommandRegistrationHandler;
import com.blamejared.crafttweaker.api.recipe.handler.IRecipeHandlerRegistry;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker.impl.command.type.conflict.DescriptiveFilter;
import com.blamejared.crafttweaker.impl.command.type.conflict.RecipeLongIterator;
import com.blamejared.crafttweaker.mixin.common.access.recipe.AccessRecipeManager;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Spliterators;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.ToIntBiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;

public final class ConflictCommand {
    private static final ExecutorService OFF_THREAD_SERVICE = Executors.newFixedThreadPool(1, r -> {
        Thread t = new Thread(r, "crafttweaker:conflict_resolution_thread");
        t.setDaemon(true);
        t.setContextClassLoader(ConflictCommand.class.getClassLoader());
        return t;
    });

    private ConflictCommand() {
    }

    public static void registerCommands(ICommandRegistrationHandler handler) {
        handler.registerRootCommand("conflicts", (MutableComponent)new TranslatableComponent("crafttweaker.command.description.conflicts"), builder -> ((LiteralArgumentBuilder)((LiteralArgumentBuilder)builder.then(Commands.argument((String)"type", (ArgumentType)RecipeTypeArgument.get()).executes(context -> ConflictCommand.conflicts((Player)((CommandSourceStack)context.getSource()).getPlayerOrException(), DescriptiveFilter.of((IRecipeManager)context.getArgument("type", IRecipeManager.class)))))).then(Commands.literal((String)"hand").executes(context -> ConflictCommand.ifNotEmpty((CommandContext<CommandSourceStack>)context, (player, item) -> ConflictCommand.conflicts(player, DescriptiveFilter.of(item)))))).executes(context -> ConflictCommand.conflicts((Player)((CommandSourceStack)context.getSource()).getPlayerOrException(), DescriptiveFilter.of())));
    }

    private static int ifNotEmpty(CommandContext<CommandSourceStack> source, ToIntBiFunction<Player, ItemStack> command) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)source.getSource()).getPlayerOrException();
        ItemStack stack = player.getMainHandItem();
        if (stack.isEmpty()) {
            CommandUtilities.send((Component)new TranslatableComponent("crafttweaker.command.conflict.hand.empty").withStyle(ChatFormatting.RED), (Player)player);
            return -1;
        }
        return command.applyAsInt((Player)player, stack);
    }

    private static int conflicts(Player player, DescriptiveFilter filter) {
        CommandUtilities.send((Component)new TranslatableComponent("crafttweaker.command.conflict.begin", new Object[]{filter.description()}).withStyle(ChatFormatting.GREEN).append((Component)new TranslatableComponent("crafttweaker.command.conflict.warnings").withStyle(ChatFormatting.RED)), player);
        ConflictCommand.runConflicts(player, player.level.getRecipeManager(), filter);
        return 0;
    }

    private static void runConflicts(Player player, RecipeManager manager, DescriptiveFilter filter) {
        Map<RecipeType<?>, Map<ResourceLocation, Recipe<?>>> recipes = ConflictCommand.deepCopy(((AccessRecipeManager)manager).crafttweaker$getRecipes(), filter);
        ((CompletableFuture)CompletableFuture.supplyAsync(() -> ConflictCommand.computeConflicts(recipes), OFF_THREAD_SERVICE).thenAcceptAsync(message -> ConflictCommand.dispatchCompletionTo(message, player), (Executor)OFF_THREAD_SERVICE)).exceptionallyAsync(exception -> ConflictCommand.dispatchExceptionTo(exception, player), (Executor)OFF_THREAD_SERVICE);
    }

    private static Map<RecipeType<?>, Map<ResourceLocation, Recipe<?>>> deepCopy(Map<RecipeType<?>, Map<ResourceLocation, Recipe<?>>> original, DescriptiveFilter filter) {
        HashMap clone = new HashMap();
        original.forEach((type, map) -> {
            Map cloneMap = clone.computeIfAbsent((RecipeType<?>)type, it -> new HashMap());
            map.entrySet().stream().filter(filter).forEach(it -> cloneMap.put((ResourceLocation)it.getKey(), (Recipe)it.getValue()));
        });
        return clone;
    }

    private static String computeConflicts(Map<RecipeType<?>, Map<ResourceLocation, Recipe<?>>> recipes) {
        return recipes.entrySet().stream().flatMap(ConflictCommand::computeConflictsFor).map(it -> "- " + it).collect(Collectors.joining("\n"));
    }

    private static Stream<String> computeConflictsFor(Map.Entry<RecipeType<?>, Map<ResourceLocation, Recipe<?>>> entry) {
        IRecipeManager<Recipe<?>> manager = RecipeTypeBracketHandler.getOrDefault(entry.getKey());
        if (manager == null || entry.getValue().size() == 1) {
            return Stream.empty();
        }
        ArrayList recipes = new ArrayList(entry.getValue().entrySet());
        RecipeLongIterator iterator = new RecipeLongIterator(recipes.size());
        int characteristics = 1300;
        return StreamSupport.longStream(Spliterators.spliterator(iterator, iterator.estimateLength(), 1300), false).filter(it -> ConflictCommand.conflictsWith(manager, (Recipe)((Map.Entry)recipes.get(RecipeLongIterator.first(it))).getValue(), (Recipe)((Map.Entry)recipes.get(RecipeLongIterator.second(it))).getValue())).mapToObj(it -> ConflictCommand.formatConflict(manager, (ResourceLocation)((Map.Entry)recipes.get(RecipeLongIterator.first(it))).getKey(), (ResourceLocation)((Map.Entry)recipes.get(RecipeLongIterator.second(it))).getKey()));
    }

    private static <T extends Recipe<?>> boolean conflictsWith(IRecipeManager<?> manager, T first, Recipe<?> second) {
        return first != second && IRecipeHandlerRegistry.getHandlerFor(first).doesConflict(manager, first, second);
    }

    private static String formatConflict(IRecipeManager<?> manager, ResourceLocation firstName, ResourceLocation secondName) {
        return String.format("Recipes '%s' and '%s' in type '%s' have conflicting inputs", firstName, secondName, manager.getCommandString());
    }

    private static void dispatchCompletionTo(String message, Player player) {
        try {
            CraftTweakerAPI.LOGGER.info(message.isEmpty() ? "No conflicts identified" : message);
            CommandUtilities.send(CommandUtilities.openingLogFile(new TranslatableComponent("crafttweaker.command.conflict.complete").withStyle(ChatFormatting.GREEN)), player);
        }
        catch (Exception e) {
            try {
                CraftTweakerAPI.LOGGER.error("An error occurred while reporting conflicts, hopefully it does not happen again", (Throwable)e);
            }
            catch (Exception another) {
                e.addSuppressed(another);
                e.printStackTrace(System.err);
            }
        }
    }

    private static Void dispatchExceptionTo(Throwable exception, Player player) {
        try {
            CraftTweakerAPI.LOGGER.error("Unable to verify for conflicts due to an exception", exception);
            CommandUtilities.send(CommandUtilities.openingLogFile(new TranslatableComponent("crafttweaker.command.conflict.error").withStyle(ChatFormatting.RED)), player);
        }
        catch (Exception e) {
            try {
                CraftTweakerAPI.LOGGER.error("An error occurred while reporting conflicts, hopefully it does not happen again", (Throwable)e);
            }
            catch (Exception another) {
                e.addSuppressed(another);
                e.printStackTrace(System.err);
            }
        }
        return null;
    }
}

