/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.command.type;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.bracket.custom.RecipeTypeBracketHandler;
import com.blamejared.crafttweaker.api.command.CommandUtilities;
import com.blamejared.crafttweaker.api.command.argument.RecipeTypeArgument;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.plugin.ICommandRegistrationHandler;
import com.blamejared.crafttweaker.api.recipe.handler.IRecipeHandlerRegistry;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker.api.util.ItemStackUtil;
import com.blamejared.crafttweaker.mixin.common.access.recipe.AccessRecipeManager;
import com.blamejared.crafttweaker.platform.Services;
import com.mojang.brigadier.arguments.ArgumentType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;

public final class RecipeCommands {
    private RecipeCommands() {
    }

    public static void registerCommands(ICommandRegistrationHandler handler) {
        handler.registerRootCommand("recipes", (MutableComponent)new TranslatableComponent("crafttweaker.command.description.recipes"), builder -> builder.executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            return RecipeCommands.dumpRecipes((Player)player);
        }));
        handler.registerSubCommand("recipes", "hand", (MutableComponent)new TranslatableComponent("crafttweaker.command.description.recipes.hand"), builder -> builder.executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            return RecipeCommands.dumpHand((Player)player, player.getMainHandItem());
        }));
        handler.registerSubCommand("recipes", "inventory", (MutableComponent)new TranslatableComponent("crafttweaker.command.description.recipes.inventory"), builder -> builder.executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            IntStream.range(0, player.getInventory().getContainerSize()).mapToObj(arg_0 -> ((Inventory)player.getInventory()).getItem(arg_0)).filter(itemStack -> !itemStack.isEmpty()).forEach(itemStack -> {
                if (stacks.stream().noneMatch(arg_0 -> ((ItemStack)itemStack).sameItemStackIgnoreDurability(arg_0))) {
                    stacks.add((ItemStack)itemStack);
                }
            });
            return RecipeCommands.dump((Player)player, stacks);
        }));
        handler.registerSubCommand("recipes", "manager", (MutableComponent)new TranslatableComponent("crafttweaker.command.description.recipes.manager"), builder -> builder.then(Commands.argument((String)"type", (ArgumentType)RecipeTypeArgument.get()).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            return RecipeCommands.dumpRecipes((Player)player, (IRecipeManager)context.getArgument("type", IRecipeManager.class));
        })));
    }

    private static int dumpRecipes(Player player) {
        CraftTweakerAPI.LOGGER.info("Dumping all recipes!");
        RecipeCommands.dumpRecipes(player, (RecipeType<?> it) -> true);
        CommandUtilities.send(CommandUtilities.openingLogFile(new TranslatableComponent("crafttweaker.command.list.check.log", new Object[]{CommandUtilities.makeNoticeable((MutableComponent)new TranslatableComponent("crafttweaker.command.misc.recipes.list")), CommandUtilities.getFormattedLogFile()}).withStyle(ChatFormatting.GREEN)), player);
        return 1;
    }

    private static int dumpRecipes(Player player, IRecipeManager<?> manager) {
        CraftTweakerAPI.LOGGER.info("Dumping recipes for manager " + manager.getCommandString() + "!");
        RecipeType<?> type = manager.getRecipeType();
        RecipeCommands.dumpRecipes(player, (RecipeType<?> it) -> Objects.equals(it, type));
        CommandUtilities.send(CommandUtilities.openingLogFile(new TranslatableComponent("crafttweaker.command.list.check.log", new Object[]{CommandUtilities.makeNoticeable((MutableComponent)new TranslatableComponent("crafttweaker.command.misc.recipes.list")), CommandUtilities.getFormattedLogFile()}).withStyle(ChatFormatting.GREEN)), player);
        return 1;
    }

    private static int dumpHand(Player player, ItemStack stack) {
        return RecipeCommands.dump(player, List.of(stack));
    }

    private static int dump(Player player, List<ItemStack> stacks) {
        for (ItemStack stack : stacks) {
            if (stack.isEmpty()) {
                CommandUtilities.send((Component)new TranslatableComponent("crafttweaker.command.recipes.hand.empty").withStyle(ChatFormatting.RED), player);
                return 1;
            }
            IItemStack workingStack = Services.PLATFORM.createMCItemStack(stack.copy()).setAmount(1);
            CraftTweakerAPI.LOGGER.info("Dumping all recipes that output {}!", (Object)ItemStackUtil.getCommandString(workingStack.getInternal()));
            ((AccessRecipeManager)player.level.getRecipeManager()).crafttweaker$getRecipes().forEach((recipeType, map) -> RecipeCommands.dumpRecipe(recipeType, map.values(), it -> workingStack.matches(Services.PLATFORM.createMCItemStack(it.getResultItem())), true));
        }
        CommandUtilities.send(CommandUtilities.openingLogFile(new TranslatableComponent("crafttweaker.command.list.check.log", new Object[]{CommandUtilities.makeNoticeable((MutableComponent)new TranslatableComponent("crafttweaker.command.misc.recipes.list")), CommandUtilities.getFormattedLogFile()}).withStyle(ChatFormatting.GREEN)), player);
        return 1;
    }

    private static void dumpRecipes(Player player, Predicate<RecipeType<?>> typeFilter) {
        ((AccessRecipeManager)player.level.getRecipeManager()).crafttweaker$getRecipes().entrySet().stream().filter(it -> typeFilter.test((RecipeType)it.getKey())).forEach(it -> RecipeCommands.dumpRecipe((RecipeType)it.getKey(), ((Map)it.getValue()).values(), recipe -> true, false));
    }

    private static void dumpRecipe(RecipeType<?> type, Collection<Recipe<?>> recipes, Predicate<Recipe<?>> filter, boolean hideEmpty) {
        IRecipeManager<Recipe<?>> manager = RecipeTypeBracketHandler.getOrDefault(type);
        if (manager == null) {
            return;
        }
        String dumpResult = recipes.stream().filter(filter).sorted(Comparator.comparing(RecipeCommands::serializer).thenComparing(Recipe::getId)).map(it -> RecipeCommands.dump(manager, it)).collect(Collectors.joining("\n  "));
        if (hideEmpty && dumpResult.isEmpty()) {
            return;
        }
        CraftTweakerAPI.LOGGER.info("Recipe type: '{}'\n  {}\n", (Object)manager.getCommandString(), (Object)(dumpResult.isEmpty() ? "No recipe found" : dumpResult));
    }

    private static ResourceLocation serializer(Recipe<?> recipe) {
        return Objects.requireNonNull(Services.REGISTRY.getRegistryKey(recipe.getSerializer()));
    }

    private static <T extends Recipe<?>> String dump(IRecipeManager<?> manager, T recipe) {
        return IRecipeHandlerRegistry.getHandlerFor(recipe).dumpToCommandString(manager, recipe);
    }
}

