/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.command.type;

import com.blamejared.crafttweaker.api.command.CommandUtilities;
import com.blamejared.crafttweaker.api.data.MapData;
import com.blamejared.crafttweaker.api.data.base.visitor.DataToTextComponentVisitor;
import com.blamejared.crafttweaker.api.plugin.ICommandRegistrationHandler;
import com.blamejared.crafttweaker.api.tag.CraftTweakerTagRegistry;
import com.blamejared.crafttweaker.api.tag.MCTag;
import com.blamejared.crafttweaker.api.tag.manager.ITagManager;
import com.blamejared.crafttweaker.api.tag.manager.type.KnownTagManager;
import com.blamejared.crafttweaker.api.tag.type.KnownTag;
import com.blamejared.crafttweaker.natives.block.ExpandBlock;
import com.blamejared.crafttweaker.natives.block.ExpandBlockState;
import com.blamejared.crafttweaker.natives.entity.attribute.ExpandAttribute;
import com.blamejared.crafttweaker.natives.entity.equipment.ExpandEquipmentSlot;
import com.blamejared.crafttweaker.platform.Services;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluids;
import org.apache.logging.log4j.util.TriConsumer;

public final class HandCommands {
    private HandCommands() {
    }

    public static void registerCommands(ICommandRegistrationHandler handler) {
        handler.registerRootCommand("hand", (MutableComponent)new TranslatableComponent("crafttweaker.command.description.hand"), builder -> builder.executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            ItemStack stack = player.getMainHandItem();
            Item item = stack.getItem();
            HandCommands.sendBasicItemInformation((Player)player, stack);
            if (item instanceof BlockItem) {
                HandCommands.sendBlockInformation((Player)player, (BlockItem)stack.getItem());
            }
            if (item instanceof BucketItem && Services.PLATFORM.getBucketContent((BucketItem)item) != Fluids.EMPTY) {
                HandCommands.sendBucketInformation((Player)player, (BucketItem)stack.getItem());
            }
            for (MutableComponent component : Services.PLATFORM.getFluidsForDump(stack, (Player)player, InteractionHand.MAIN_HAND)) {
                HandCommands.sendHand((Player)player, (MutableComponent)new TranslatableComponent("crafttweaker.command.misc.fluid"), component.getString());
            }
            HandCommands.sendTagsInformation((Player)player, item);
            return 1;
        }));
        handler.registerSubCommand("hand", "registry_name", (MutableComponent)new TranslatableComponent("crafttweaker.command.description.hand.registryname"), builder -> builder.executes(context -> {
            ItemStack mainHandItem = ((CommandSourceStack)context.getSource()).getPlayerOrException().getMainHandItem();
            HandCommands.sendCopyingHand((Player)((CommandSourceStack)context.getSource()).getPlayerOrException(), (MutableComponent)new TranslatableComponent("crafttweaker.command.misc.item"), Services.REGISTRY.getRegistryKey(mainHandItem.getItem()).toString());
            return 1;
        }));
        handler.registerSubCommand("hand", "data", (MutableComponent)new TranslatableComponent("crafttweaker.command.description.hand.data"), builder -> builder.executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            ItemStack stack = player.getMainHandItem();
            if (!stack.hasTag()) {
                CommandUtilities.send((Component)new TranslatableComponent("crafttweaker.command.hand.no.data"), (Player)player);
                return 0;
            }
            HandCommands.sendCopyingHand((Player)player, (MutableComponent)new TranslatableComponent("crafttweaker.command.misc.data"), new MapData(stack.getTag()).accept(new DataToTextComponentVisitor(" ", 0)).getString());
            return 1;
        }));
        handler.registerSubCommand("hand", "tags", (MutableComponent)new TranslatableComponent("crafttweaker.command.description.hand.tags"), builder -> builder.executes(context -> {
            ItemStack stack;
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            Collection<String> tags = HandCommands.sendTagsInformation((Player)player, (stack = player.getMainHandItem()).getItem());
            if (tags.isEmpty()) {
                CommandUtilities.send((Component)new TranslatableComponent("crafttweaker.command.hand.no.tags"), (Player)player);
                return 1;
            }
            tags.stream().findFirst().ifPresent(it -> CommandUtilities.copy((Player)player, it));
            return 1;
        }));
        handler.registerSubCommand("hand", "vanilla", (MutableComponent)new TranslatableComponent("crafttweaker.command.description.hand.vanilla"), builder -> builder.executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            ItemStack stack = player.getMainHandItem();
            Item item = stack.getItem();
            HandCommands.sendBasicVanillaItemInformation((Player)player, stack);
            if (stack.hasTag()) {
                HandCommands.sendVanillaDataInformation((Player)player, (Tag)Objects.requireNonNull(stack.getTag()));
            }
            if (item instanceof BucketItem && Services.PLATFORM.getBucketContent((BucketItem)item) != Fluids.EMPTY) {
                HandCommands.sendVanillaBucketInformation((Player)player, (BucketItem)stack.getItem());
            }
            HandCommands.sendVanillaTagsInformation((Player)player, item);
            return 1;
        }));
        handler.registerSubCommand("hand", "attributes", (MutableComponent)new TranslatableComponent("crafttweaker.command.description.hand.attributes"), builder -> builder.executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            ItemStack stack = player.getMainHandItem();
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                Map modifiers = stack.getAttributeModifiers(slot).asMap();
                if (modifiers.isEmpty()) continue;
                String equipmentCS = ExpandEquipmentSlot.getCommandString(slot);
                CommandUtilities.sendCopying(new TranslatableComponent("crafttweaker.command.hand.header.attributes").append(": ").append((Component)new TextComponent(equipmentCS).withStyle(ChatFormatting.GREEN)).withStyle(ChatFormatting.DARK_AQUA), equipmentCS, (Player)player);
                modifiers.forEach((attribute, attributeModifiers) -> {
                    String attributeCS = ExpandAttribute.getCommandString(attribute);
                    CommandUtilities.sendCopying(new TextComponent("- ").withStyle(ChatFormatting.YELLOW).append((Component)new TextComponent(attributeCS).withStyle(ChatFormatting.GREEN)), attributeCS, (Player)player);
                    attributeModifiers.forEach(attributeModifier -> {
                        HandCommands.sendAttributePropertyInformation((Player)player, "Name", attributeModifier.getName());
                        HandCommands.sendAttributePropertyInformation((Player)player, "ID", attributeModifier.getId().toString());
                        HandCommands.sendAttributePropertyInformation((Player)player, "Operation", attributeModifier.getOperation().name());
                        HandCommands.sendAttributePropertyInformation((Player)player, "Amount", "" + attributeModifier.getAmount());
                        HandCommands.sendAttributePropertyInformation((Player)player, "IData", new MapData(attributeModifier.save()).asString());
                    });
                });
            }
            HandCommands.sendCopyingHand((Player)player, (MutableComponent)new TranslatableComponent("crafttweaker.command.misc.item"), Services.REGISTRY.getRegistryKey(stack.getItem()).toString());
            return 1;
        }));
    }

    private static void sendBasicItemInformation(Player player, ItemStack target) {
        String output = Services.PLATFORM.createMCItemStackMutable(target).getCommandString();
        HandCommands.sendCopyingHand(player, (MutableComponent)new TranslatableComponent("crafttweaker.command.misc.item"), output);
    }

    private static void sendBlockInformation(Player player, BlockItem target) {
        HandCommands.sendBlockInformation(player, target.getBlock());
    }

    private static void sendBlockInformation(Player player, Block target) {
        HandCommands.sendHand(player, (MutableComponent)new TranslatableComponent("crafttweaker.command.misc.block"), ExpandBlock.getCommandString(target));
        HandCommands.sendHand(player, (MutableComponent)new TranslatableComponent("crafttweaker.command.misc.blockstate"), ExpandBlockState.getCommandString(target.defaultBlockState()));
    }

    private static void sendBucketInformation(Player player, BucketItem target) {
        if (Services.PLATFORM.getBucketContent(target) == Fluids.EMPTY) {
            return;
        }
        HandCommands.sendHand(player, (MutableComponent)new TranslatableComponent("crafttweaker.command.misc.fluidblockstate"), ExpandBlockState.getCommandString(Services.PLATFORM.getBucketContent(target).defaultFluidState().createLegacyBlock()));
    }

    private static Collection<String> sendTagsInformation(Player player, Item item) {
        ArrayList<String> tags = new ArrayList<String>(HandCommands.sendItemTagsInformation(player, item));
        if (item instanceof BlockItem) {
            tags.addAll(HandCommands.sendBlockTagsInformation(player, (BlockItem)item));
        }
        return tags;
    }

    private static Collection<String> sendItemTagsInformation(Player player, Item item) {
        return HandCommands.sendTagsInformation(player, (MutableComponent)new TranslatableComponent("crafttweaker.command.hand.header.tags.item"), CraftTweakerTagRegistry.INSTANCE.knownTagManager(Registry.ITEM_REGISTRY), item);
    }

    private static Collection<String> sendBlockTagsInformation(Player player, BlockItem item) {
        return HandCommands.sendTagsInformation(player, (MutableComponent)new TranslatableComponent("crafttweaker.command.hand.header.tags.block"), CraftTweakerTagRegistry.INSTANCE.knownTagManager(Registry.BLOCK_REGISTRY), item.getBlock());
    }

    private static <T> Collection<String> sendTagsInformation(Player player, MutableComponent header, KnownTagManager<?> manager, T target) {
        Holder<T> tHolder = Services.REGISTRY.makeHolder(manager.resourceKey(), target);
        if (tHolder.tags().findAny().isEmpty()) {
            return List.of();
        }
        CommandUtilities.send((Component)header.withStyle(ChatFormatting.DARK_AQUA), player);
        return tHolder.tags().map(tTagKey -> new KnownTag(tTagKey.location(), manager)).map(MCTag::getCommandString).peek(it -> HandCommands.sendTagHand(player, it)).toList();
    }

    private static void sendBasicVanillaItemInformation(Player player, ItemStack target) {
        String output = Objects.requireNonNull(Services.REGISTRY.getRegistryKey(target.getItem())).toString();
        HandCommands.sendCopyingHand(player, (MutableComponent)new TranslatableComponent("crafttweaker.command.misc.item"), output);
    }

    private static void sendVanillaDataInformation(Player player, Tag nbt) {
        HandCommands.sendHand(player, (MutableComponent)new TranslatableComponent("crafttweaker.command.misc.data"), nbt.toString());
    }

    private static void sendVanillaBucketInformation(Player player, BucketItem target) {
        if (Services.PLATFORM.getBucketContent(target) == Fluids.EMPTY) {
            return;
        }
        HandCommands.sendHand(player, (MutableComponent)new TranslatableComponent("crafttweaker.command.misc.fluidblockstate"), Services.REGISTRY.getRegistryKey(Services.PLATFORM.getBucketContent(target)).toString());
    }

    private static void sendVanillaTagsInformation(Player player, Item item) {
        HandCommands.sendVanillaItemTagsInformation(player, item);
        if (item instanceof BlockItem) {
            HandCommands.sendVanillaBlockTagsInformation(player, (BlockItem)item);
        }
    }

    private static void sendVanillaItemTagsInformation(Player player, Item item) {
        HandCommands.sendVanillaTagsInformation(player, (MutableComponent)new TranslatableComponent("crafttweaker.command.hand.header.tags.item"), CraftTweakerTagRegistry.INSTANCE.tagManager(Registry.ITEM_REGISTRY), item);
    }

    private static void sendVanillaBlockTagsInformation(Player player, BlockItem item) {
        HandCommands.sendVanillaTagsInformation(player, (MutableComponent)new TranslatableComponent("crafttweaker.command.hand.header.tags.block"), CraftTweakerTagRegistry.INSTANCE.tagManager(Registry.BLOCK_REGISTRY), item.getBlock());
    }

    private static <T> void sendVanillaTagsInformation(Player player, MutableComponent header, ITagManager<?> manager, T target) {
        Holder<T> tHolder = Services.REGISTRY.makeHolder(manager.resourceKey(), target);
        if (tHolder.tags().findAny().isEmpty()) {
            return;
        }
        CommandUtilities.send((Component)header.withStyle(ChatFormatting.DARK_AQUA), player);
        tHolder.tags().map(tTagKey -> "#" + tTagKey.location()).forEach(it -> HandCommands.sendTagHand(player, it));
    }

    private static void sendAttributePropertyInformation(Player player, String propertyName, String value) {
        CommandUtilities.sendCopying(new TextComponent("    - ").append(propertyName).append(": ").withStyle(ChatFormatting.YELLOW).append((Component)new TextComponent(value).withStyle(ChatFormatting.AQUA)), value, player);
    }

    private static void sendHand(Player receiver, MutableComponent messagePrefix, String target) {
        HandCommands.sendHand(receiver, messagePrefix, target, (TriConsumer<MutableComponent, String, Player>)((TriConsumer)CommandUtilities::sendCopying));
    }

    private static void sendCopyingHand(Player receiver, MutableComponent messagePrefix, String target) {
        HandCommands.sendHand(receiver, messagePrefix, target, (TriConsumer<MutableComponent, String, Player>)((TriConsumer)CommandUtilities::sendCopyingAndCopy));
    }

    private static void sendHand(Player receiver, MutableComponent messagePrefix, String target, TriConsumer<MutableComponent, String, Player> consumer) {
        consumer.accept((Object)messagePrefix.append(": ").append((Component)new TextComponent(target).withStyle(ChatFormatting.GREEN)), (Object)target, (Object)receiver);
    }

    private static void sendTagHand(Player receiver, String tag) {
        CommandUtilities.sendCopying(new TranslatableComponent("    ").append((Component)new TextComponent("- ").withStyle(ChatFormatting.YELLOW)).append(" ").append((Component)new TextComponent(tag).withStyle(ChatFormatting.AQUA)), tag, receiver);
    }
}

