/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.util;

import com.blamejared.crafttweaker.api.data.MapData;
import com.blamejared.crafttweaker.api.data.base.converter.tag.TagToDataConverter;
import com.blamejared.crafttweaker.platform.Services;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;

public final class ItemStackUtil {
    public static String getCommandString(ItemStack stack) {
        return ItemStackUtil.getCommandString(stack, false);
    }

    public static String getCommandString(ItemStack stack, boolean mutable) {
        StringBuilder sb = new StringBuilder("<item:");
        sb.append(Services.REGISTRY.getRegistryKey(stack.getItem()));
        sb.append('>');
        if (stack.getTag() != null) {
            MapData data = TagToDataConverter.convertCompound(stack.getTag()).copyInternal();
            if (stack.getItem().canBeDepleted()) {
                data.remove("Damage");
            }
            if (!data.isEmpty()) {
                sb.append(".withTag(");
                sb.append(data.asString());
                sb.append(')');
            }
        }
        if (stack.getDamageValue() > 0) {
            sb.append(".withDamage(").append(stack.getDamageValue()).append(')');
        }
        if (!stack.isEmpty() && stack.getCount() != 1) {
            sb.append(" * ").append(stack.getCount());
        }
        if (mutable) {
            sb.append(".mutable()");
        }
        return sb.toString();
    }

    public static boolean areStacksTheSame(ItemStack first, ItemStack second) {
        if (first.isEmpty() != second.isEmpty()) {
            return false;
        }
        if (first.getItem() != second.getItem()) {
            return false;
        }
        if (first.getCount() > second.getCount()) {
            return false;
        }
        if (first.getDamageValue() != second.getDamageValue()) {
            return false;
        }
        CompoundTag firstTag = first.getTag();
        CompoundTag secondTag = second.getTag();
        if (firstTag == null) {
            return true;
        }
        if (secondTag == null) {
            return false;
        }
        return firstTag.equals((Object)secondTag);
    }
}

