/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.util;

import com.blamejared.crafttweaker.platform.Services;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;

public class AttributeUtil {
    public static void addAttributeModifier(ItemStack stack, Attribute attributeName, AttributeModifier modifier, @Nullable EquipmentSlot equipmentSlot) {
        CompoundTag tag = stack.getOrCreateTagElement("CraftTweakerData");
        if (!tag.contains("AttributeModifiers", 9)) {
            tag.put("AttributeModifiers", (Tag)new ListTag());
        }
        ListTag listnbt = tag.getList("AttributeModifiers", 10);
        CompoundTag compoundnbt = modifier.save();
        compoundnbt.putString("AttributeName", Services.REGISTRY.getRegistryKey(attributeName).toString());
        if (equipmentSlot != null) {
            compoundnbt.putString("Slot", equipmentSlot.getName());
        }
        listnbt.add((Object)compoundnbt);
    }

    public static Map<Attribute, List<AttributeModifier>> getAttributeModifiers(ItemStack stack, EquipmentSlot equipmentSlot) {
        HashMap<Attribute, List<AttributeModifier>> map = new HashMap<Attribute, List<AttributeModifier>>();
        CompoundTag tag = stack.getOrCreateTagElement("CraftTweakerData");
        if (!tag.contains("AttributeModifiers", 9)) {
            return map;
        }
        ListTag listnbt = tag.getList("AttributeModifiers", 10);
        for (int i = 0; i < listnbt.size(); ++i) {
            CompoundTag compoundnbt = listnbt.getCompound(i);
            if (compoundnbt.contains("Slot", 8) && !compoundnbt.getString("Slot").equals(equipmentSlot.getName())) continue;
            Optional<Attribute> optional = Services.REGISTRY.attributes().getOptional(ResourceLocation.tryParse((String)compoundnbt.getString("AttributeName")));
            optional.ifPresent(attribute -> {
                AttributeModifier attributemodifier = AttributeModifier.load((CompoundTag)compoundnbt);
                if (attributemodifier != null && attributemodifier.getId().getLeastSignificantBits() != 0L && attributemodifier.getId().getMostSignificantBits() != 0L) {
                    map.computeIfAbsent((Attribute)attribute, key -> new ArrayList()).add(attributemodifier);
                }
            });
        }
        return map;
    }
}

