/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.tag.manager.type;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.action.tag.known.ActionKnownTagAdd;
import com.blamejared.crafttweaker.api.action.tag.known.ActionKnownTagClear;
import com.blamejared.crafttweaker.api.action.tag.known.ActionKnownTagCreate;
import com.blamejared.crafttweaker.api.action.tag.known.ActionKnownTagRemove;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.tag.MutableLoadResult;
import com.blamejared.crafttweaker.api.tag.manager.ITagManager;
import com.blamejared.crafttweaker.api.tag.type.KnownTag;
import com.blamejared.crafttweaker.api.util.GenericUtil;
import com.blamejared.crafttweaker.mixin.common.access.tag.AccessTag;
import com.blamejared.crafttweaker.platform.Services;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.Tag;
import net.minecraft.tags.TagManager;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@Document(value="vanilla/api/tag/manager/type/KnownTagManager")
@ZenCodeType.Name(value="crafttweaker.api.tag.manager.type.KnownTagManager")
public class KnownTagManager<T>
implements ITagManager<KnownTag<T>> {
    private final ResourceKey<? extends Registry<T>> resourceKey;
    private final Class<T> elementClass;
    private final MutableLoadResult<T> backingResult;
    private Map<ResourceLocation, KnownTag<T>> tagCache;

    public KnownTagManager(ResourceKey<? extends Registry<T>> resourceKey, Class<T> elementClass) {
        this.resourceKey = resourceKey;
        this.elementClass = elementClass;
        this.backingResult = new MutableLoadResult();
        this.tagCache = new HashMap<ResourceLocation, KnownTag<T>>();
    }

    @Override
    public Optional<Class<?>> elementClass() {
        return Optional.of(this.elementClass);
    }

    @Override
    public ResourceKey<? extends Registry<T>> resourceKey() {
        return this.resourceKey;
    }

    @SafeVarargs
    @ZenCodeType.Method
    public final void addElements(KnownTag<T> to, T ... values) {
        if (!this.exists(to)) {
            CraftTweakerAPI.apply(new ActionKnownTagCreate<T>(to));
        }
        CraftTweakerAPI.apply(new ActionKnownTagAdd<T>(to, List.of(values)));
        this.recalculate();
    }

    @Override
    public void addId(KnownTag<T> to, ResourceLocation ... values) {
        if (!this.exists(to)) {
            CraftTweakerAPI.apply(new ActionKnownTagCreate<T>(to));
        }
        List<Object> actualValues = Arrays.stream(values).map(resourceLocation -> Services.REGISTRY.makeHolder((ResourceKey<?>)this.resourceKey(), (ResourceLocation)resourceLocation)).map(Holder::value).map(o -> o).toList();
        CraftTweakerAPI.apply(new ActionKnownTagAdd<Object>(to, actualValues));
        this.recalculate();
    }

    @Override
    @ZenCodeType.Method
    public final void removeId(KnownTag<T> from, ResourceLocation ... values) {
        if (!this.exists(from)) {
            throw new IllegalArgumentException("Cannot remove elements from empty tag: " + from);
        }
        List<Object> actualValues = Arrays.stream(values).map(resourceLocation -> Services.REGISTRY.makeHolder((ResourceKey<?>)this.resourceKey(), (ResourceLocation)resourceLocation)).map(Holder::value).map(o -> o).toList();
        CraftTweakerAPI.apply(new ActionKnownTagRemove<Object>(from, actualValues));
        this.recalculate();
    }

    @Override
    public void clear(KnownTag<T> from) {
        if (!this.exists(from)) {
            throw new IllegalArgumentException("Cannot clear elements of an empty tag: " + from);
        }
        CraftTweakerAPI.apply(new ActionKnownTagClear<T>(from));
        this.recalculate();
    }

    @ZenCodeType.Method
    public List<T> elements(KnownTag<T> of) {
        if (!this.exists(of)) {
            return List.of();
        }
        return this.getInternal(of).getValues().stream().map(Holder::value).collect(Collectors.toList());
    }

    @SafeVarargs
    @ZenCodeType.Method
    public final void removeElements(KnownTag<T> from, T ... values) {
        if (!this.exists(from)) {
            throw new IllegalArgumentException("Cannot remove elements from empty tag: " + from);
        }
        CraftTweakerAPI.apply(new ActionKnownTagRemove<T>(from, List.of(values)));
        this.recalculate();
    }

    @Override
    @ZenCodeType.Method
    public KnownTag<T> tag(String id) {
        return this.tag(new ResourceLocation(id));
    }

    @Override
    @ZenCodeType.Method
    public KnownTag<T> tag(ResourceLocation id) {
        return this.tagMap().getOrDefault(id, new KnownTag(id, this));
    }

    @Override
    public void recalculate() {
        this.tagCache = this.backingResult.tagMap().keySet().stream().map(id -> Pair.of((Object)id, new KnownTag((ResourceLocation)id, this))).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond));
    }

    @Override
    @ZenCodeType.Method
    @ZenCodeType.Getter(value="tagMap")
    public Map<ResourceLocation, KnownTag<T>> tagMap() {
        if (this.tagCache.isEmpty()) {
            this.recalculate();
        }
        return this.tagCache;
    }

    @Override
    public Map<ResourceLocation, Tag<Holder<?>>> internalTags() {
        return (Map)GenericUtil.uncheck(Collections.unmodifiableMap(this.backingResult.tagMap()));
    }

    @Nullable
    public Tag<Holder<T>> getInternal(KnownTag<T> tag) {
        return this.backingResult.tagMap().get(tag.id());
    }

    @Override
    @Nullable
    public Tag<Holder<?>> getInternalRaw(KnownTag<T> tag) {
        return (Tag)GenericUtil.uncheck(this.getInternal(tag));
    }

    @Override
    public List<ResourceLocation> tagKeys() {
        return new ArrayList<ResourceLocation>(this.tagMap().keySet());
    }

    @Override
    public <U> void addTag(ResourceLocation id, Tag<Holder<U>> tag) {
        AccessTag accessTag = (AccessTag)tag;
        accessTag.crafttweaker$setElements(new ArrayList(accessTag.crafttweaker$getElements()));
        this.backingResult.addTag(id, (Tag)GenericUtil.uncheck(tag));
        this.recalculate();
    }

    @Override
    public void bind(TagManager.LoadResult<?> result) {
        this.backingResult.bind(result);
    }

    @ZenCodeType.Method
    public List<KnownTag<T>> getTagsFor(T element) {
        return this.tags().stream().filter(tag -> tag.contains(element)).toList();
    }
}

