/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.tag.manager;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.bracket.CommandStringDisplayable;
import com.blamejared.crafttweaker.api.tag.CraftTweakerTagRegistry;
import com.blamejared.crafttweaker.api.tag.MCTag;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.Tag;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagManager;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister(loaders={"crafttweaker", "tags"})
@Document(value="vanilla/api/tag/manager/ITagManager")
@ZenCodeType.Name(value="crafttweaker.api.tag.manager.ITagManager")
public interface ITagManager<T extends MCTag>
extends CommandStringDisplayable,
Iterable<T> {
    @ZenCodeType.Method
    @ZenCodeType.Getter(value="tagFolder")
    default public String tagFolder() {
        return CraftTweakerTagRegistry.INSTANCE.makeTagFolder(this.resourceKey());
    }

    @ZenCodeType.Method
    public T tag(String var1);

    @ZenCodeType.Method
    public T tag(ResourceLocation var1);

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="tagMap")
    public Map<ResourceLocation, T> tagMap();

    @ZenCodeType.Method
    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.CONTAINS)
    default public boolean exists(String id) {
        return this.exists(new ResourceLocation(id));
    }

    @ZenCodeType.Method
    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.CONTAINS)
    default public boolean exists(ResourceLocation id) {
        return this.tagKeys().contains(id);
    }

    @ZenCodeType.Method
    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.CONTAINS)
    default public boolean exists(T tag) {
        return this.exists(tag.id());
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="tagKeys")
    public List<ResourceLocation> tagKeys();

    @Override
    default public String getCommandString() {
        return "<tagmanager:" + this.tagFolder() + ">";
    }

    public <U> void addTag(ResourceLocation var1, Tag<Holder<U>> var2);

    public Map<ResourceLocation, Tag<Holder<?>>> internalTags();

    public void bind(TagManager.LoadResult<?> var1);

    default public Optional<Class<?>> elementClass() {
        return Optional.empty();
    }

    @ZenCodeType.Method
    public void addId(T var1, ResourceLocation ... var2);

    @ZenCodeType.Method
    public void removeId(T var1, ResourceLocation ... var2);

    @ZenCodeType.Method
    public void clear(T var1);

    @ZenCodeType.Method
    default public List<ResourceLocation> idElements(T of) {
        if (!this.exists(of)) {
            return List.of();
        }
        return this.getInternalRaw(of).getValues().stream().map(Holder::unwrapKey).filter(Optional::isPresent).map(Optional::get).map(ResourceKey::location).collect(Collectors.toList());
    }

    @Nullable
    public Tag<Holder<?>> getInternalRaw(T var1);

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="tags")
    default public List<T> tags() {
        return new ArrayList<T>(this.tagMap().values());
    }

    @ZenCodeType.Method
    default public List<T> getTagsFor(ResourceLocation element) {
        return this.tags().stream().filter(tag -> tag.contains(element)).toList();
    }

    public ResourceKey<? extends Registry<?>> resourceKey();

    public void recalculate();

    default public T tag(TagKey<?> key) {
        return this.tag(key.location());
    }

    @Override
    @Nonnull
    default public Iterator<T> iterator() {
        return this.tags().iterator();
    }
}

